;+
; NAME:
;       ADD_OPTICAL_MODULE
;
; PURPOSE:
;		this procedure create an optic_module and add it in the current optical system
;
; CATEGORY:
;       optic.
;
; CALLING SEQUENCE:
;       ADD_optical_module, dim, pInfo
;
; INPUTS:
;		dim : a structure to define the new module propertys
;		pInfo: a pointer on the uvalue of blviewer
;
; KEYWORD PARAMETERS:
;
; MODIFICATION HISTORY:
;       Written by:     ESRF, EXP, May 2001.
;-

;********************add optic element********************
pro blv_add_optical_module, dim, pInfo

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Catch, /cancel
   Message,/Info,'error caught: '+!error_state.msg
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
        'blv_add_optical_module: error caught: '+!error_state.msg)
   RETURN
ENDIF


optic=blv_create_optical_module(dim)

(*pInfo).data.system->add_module, optic, pos=(*pInfo).data.position+1
;blv_no_show_element, pInfo
(*pInfo).data.position=(*pInfo).data.position+1
;blv_show_element, pInfo

(*pInfo).data.system->trace
if (*pInfo).wid.wModule ne (*pInfo).wid.tbl then begin
	widget_control,(*pInfo).wid.wModule, get_uvalue=info
	widget_control, (*info.pInfoModule).wNbModule, set_value=string((*pInfo).data.system->count())
	widget_control, (*info.pInfoModule).wSelectedModule, set_value=(*pInfo).data.position+1
	blv_change_selected_module, pInfo
endif

end
;********************************
