pro  WRITEPAR_LAUE, parameters,beamsize=beamsize,sample_depth=sample_depth,$
	dark_current=dark_current,boxsize=boxsize,gain=gain,$
	noise_percentage=noise_percentage
;+
; NAME:
;	WRITEPAR_LAUE
;
; PURPOSE:
;
;	To type in the experimental parameters of a Laue experiment.unless
;	they are given by keywords
;
; CATEGORY:
;	Laue processing
;
; CALLING SEQUENCE:
;	WRITEPAR_LAUE,parameters,beamsize=beamsize,sample_depth=sample_depth,$
;	dark_current=dark_current,boxsize=boxsize,gain=gain,$
;	noise_percentage=noise_percentage
;
; INPUTS:
;	parameters : the experimental parameters
;	beamsize : beamsize
;	sample_depth : sample depth
;	dark_current : dark_current in the detector
;	boxsize : boxsize for integration
;	gain : gain of the detector
;	noise_percentage : the percentage of the pixels in the integration 
;			box to be taken as background 
; OUTPUTS:
;	the experimental parameters par are modified.
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;
; PROCEDURE:
;	Straightforward
;	
; MODIFICATION HISTORY:
;	D.Bourgeois, May 1994.
;-

;on_error,2                              ;Return to caller if an error occurs

;PRINT,' ***  Experimental parameters for Laue experiment ***'
;PRINT,''
;PRINT,''
IF NOT KEYWORD_SET(beamsize) THEN READ,'Enter the beamsize (assume a square beamsize) [mm] :',beamsize
IF NOT KEYWORD_SET(sample_depth) THEN READ,'Enter the sample depth [mm] :',sample_depth
IF NOT KEYWORD_SET(dark_current) THEN READ,'Enter the dark current in the detector [counts] :',dark_current
IF NOT KEYWORD_SET(boxsize) THEN READ,'Enter the x and y boxsizes for integration [rasterx,rastery] :',boxsize.x,boxsize.y
IF NOT KEYWORD_SET(gain) THEN READ,'Enter the gain of the detector :',gain
IF NOT KEYWORD_SET(noise_percentage) THEN READ,'Enter the percentage of the pixels in the integration box to be taken as background :',noise_percentage


parameters.noise_percentage = noise_percentage
parameters.beamsize = beamsize
parameters.gain = gain
parameters.dark_current = dark_current
parameters.sample_depth = sample_depth
parameters.boxsize = boxsize
;HELP,parameters,/struc

END

