FUNCTION READ_IP,display=display,no_rotate=no_rotate,file=file,beamline=beamline
;+
; NAME:
;	READ_IP
;
; PURPOSE:
;	Reads in Molecular Dynamics Image Plate files (TIFF format)
;
; CATEGORY:
;	Input/output.
;
; CALLING SEQUENCE:
;   Result = READ_IP(file=file,/display,no_rotate=no_rotate)
;
; INPUTS:
; 	Display : set this keyword to display the Log of the image
;	no_rotate : set this keyword not to rotate the image
;	beamline : set this keyword to rotate the image by 180 deg, ie
;		like in ID9 with DIS (TOP=TOP, TOWARDS SOURCE)
;	file : a filename
;
; OUTPUTS:
;	READ_IP returns a long array containing the image data.
;
;
; SIDE EFFECTS:
;	A file is read.
;
;
;
; MODIFICATION HISTORY:
;       Written by Dominique BOURGEOIS, April 1994
;-

;on_error,2                      ;Return to caller if an error occurs

;open the file

IF N_ELEMENTS(file) EQ 0 THEN BEGIN
 file=PICKFILE(/READ,PATH=GETENV('DATA_DIR'),FILTER=['*.gel'])
ENDIF
 image = IQ_READ(file)

 size1=SIZE(image)
 rows=size1(1)
 columns=size1(2)

IF NOT KEYWORD_SET(no_rotate) AND NOT KEYWORD_SET(beamline) THEN BEGIN
 PRINT,'Rotating image (top_display=right_image,towards source) ...'
 image=ROTATE(TEMPORARY(image),3)
 tmp=rows & rows=columns & columns=tmp
ENDIF

IF NOT KEYWORD_SET(no_rotate) AND KEYWORD_SET(beamline) THEN BEGIN
 PRINT,'Rotating image as in DIS (TOP=TOP, TOWARDS SOURCE)...'
 image=ROTATE(TEMPORARY(image),7)
ENDIF

PRINT,"Image size (hori,vert):",rows,columns

;following trick gives the right window number on the title
IF KEYWORD_SET(display) THEN BEGIN
 WINDOW,!d.window+1,title=file+'  window:'+STRING(!D.WINDOW+1),xsize=rows/display,ysize=columns/display
 PRINT,'Displaying on window : ',!D.WINDOW
 IF display NE 1 THEN TVSCL,ALOG(REBIN(image,rows/display,columns/display)>1) ELSE TVSCL,alog(image>1)
ENDIF
 
RETURN, image

END






















