function CALC_ROTATION2, x
;+
; NAME:
;	CALC_ROTATION2
;
; PURPOSE:
;	See CALC_ROTATION. This is a subroutine used for numerical
;	solution for PhiX in a very special case.
;	Only used in call from FX_ROOT.
;
; CATEGORY:
;	Laue data processing, Crystallography
;
; CALLING SEQUENCE:
; 	result= CALC_ROTATION2(x)
;
; INPUTS:
;	X:
;
; KEYWORDED PARAMETERS:
;
; OUTPUTS:
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;
; RESTRICTIONS:
;
; PROCEDURE:
;	
; MODIFICATION HISTORY:
;	Written by Thomas Ursby, September 1995
;
;-
COMMON calc_rot_par, cry, crz, crmat01

RETURN, cos(crz) * sin(x) * sin(cry) - cos(x) * sin(crz) - crmat01

END
