function PIXLAUE2,struc,reb,image,par,draw=draw,color=color,print=print,region=region,reg_color=reg_color
;+
; NAME:
;	PIXLAUE2
;
; PURPOSE:
;	Simply gives the position in pixels of a spot, on the rebinned image
;	rebinned by a factor of reb. Additionnaly, draws squares around the predicted spots, on the
;	image red.
;
;
; CATEGORY:
;	Laue processing
;
; CALLING SEQUENCE:
;	position = PIXLAUE(struc, reb, image, par,draw=draw,color=color,region=region,reg_color=reg_color)
;
; INPUTS:
;	image : the original image
;	reb : the rebinning factor
;	struc : a reflection list (a structure produced with the
;	        routine READ_GEASC2 or equivalent). Must contain the following
;		fields : .x ; .y
;	par : the parameter from the routine READ_GEASC2 or equivalent). 
;	      Must contain the following fields : .cenx ; .ceny ; .yscale ;
;	      .raster.
;	draw : keyword set if the spots are to be marked on the screen. Draw
;		is the size of the square to be used
;	region : if this keyword is used then the shape in par.region is shown
;	color : the boxes are painted with color=!D.N_COLORS-color
;	print : keyword set if the coordinates of the spots are to be printed
;	reg_color : the regions are painted with color=!D.N_COLORS-reg_color
;
; OUTPUTS:
;	pos : the positions of the spots on the rebinned image
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;
; PROCEDURE:
;	Quite straightforward
;
; MODIFICATION HISTORY:
;	D.Bourgeois, February 1994.
;-

!ERR = 0
;position of the center of the image
centerX = par.cenx-1
centerY = par.ceny-1

;y scale
scaleY = par.yscale

;size of "image"
imageX = (size(image))(1)
imageY = (size(image))(2)
;size of "rebinned image"
redX = imageX/reb
redY = imageY/reb

;original pixel size [micrometers]
pix_size = par.raster
pix_sizeX = 0.001*pix_size
pix_sizeY = 0.001*pix_size/scaleY

pos = LONARR((SIZE(struc))(1),2)

  IF KEYWORD_SET(region) THEN BEGIN
   ;is the tag "overall_region" existing in par
   exist=0
   FOR loc_i=0,N_TAGS(par)-1 DO BEGIN
    IF (TAG_NAMES(par))(loc_i) EQ 'OVERALL_REGION' THEN exist=1
   ENDFOR
   IF exist EQ 0 THEN MESSAGE,'Region not existing in structure : par !'
   reg=par.overall_region
   gen_reg=LONARR(par.boxsize.x,par.boxsize.y) & gen_reg(*)=1
   gen_reg(reg)=0
   w_reg=WHERE(gen_reg EQ 1,ct_reg)
   IF ct_reg EQ 0 THEN MESSAGE,'Region is empty !'
   border_reg=w_reg
   xy_reg = WHERESUB(w_reg,gen_reg)	
   ;select the border
   FOR loc_i=0,ct_reg-1 DO BEGIN
    x = FLOAT(xy_reg(loc_i)) & y = IMAGINARY(xy_reg(loc_i))
    ;must check for [x-1,y-1],[x,y-1],[x+1,y-1],[x-1,y],[x+1,y],[x-1,y+1],[x,y+1],[x+1,y+1]
    w_check = WHERE( 	(FLOAT(xy_reg) EQ (x-1) AND IMAGINARY(xy_reg) EQ (y-1)) OR $
			(FLOAT(xy_reg) EQ (x) AND IMAGINARY(xy_reg) EQ (y-1)) OR $
			(FLOAT(xy_reg) EQ (x+1) AND IMAGINARY(xy_reg) EQ (y-1)) OR $
			(FLOAT(xy_reg) EQ (x-1) AND IMAGINARY(xy_reg) EQ (y)) OR $
			(FLOAT(xy_reg) EQ (x+1) AND IMAGINARY(xy_reg) EQ (y)) OR $
			(FLOAT(xy_reg) EQ (x-1) AND IMAGINARY(xy_reg) EQ (y+1)) OR $
			(FLOAT(xy_reg) EQ (x) AND IMAGINARY(xy_reg) EQ (y+1)) OR $
			(FLOAT(xy_reg) EQ (x+1) AND IMAGINARY(xy_reg) EQ (y+1)), $
			ct_check)
   IF ct_check LT 8 THEN border_reg(loc_i)=1 ELSE border_reg(loc_i)=0
   ENDFOR
   xy_border=xy_reg(WHERE(border_reg EQ 1,ct_border))   
   ;gen_border = gen_reg & gen_border(*)=0 & gen_border(w_reg(WHERE(border_reg EQ 1)))=1 
   ;SURFACE,gen_border

   ;need to reorganize 
   used_border=BYTARR(ct_border+1)
   xy_border2=xy_border
   used_border(0)=1 &   used_border(ct_border)=1
   FOR loc_i=0,ct_border-2 DO BEGIN
    w_free = WHERE(used_border EQ 0,ct_free)
    min_dist = MIN(FLOAT(xy_border(w_free)-xy_border2(loc_i))^2 + IMAGINARY(xy_border(w_free)-xy_border2(loc_i))^2)
    w=WHERE(FLOAT(xy_border(w_free)-xy_border2(loc_i))^2 + IMAGINARY(xy_border(w_free)-xy_border2(loc_i))^2 EQ min_dist)
    w=w(0)
    xy_border2(loc_i+1)=xy_border(w_free(w))
    used_border(w_free(w))=1
   ENDFOR


  ENDIF

i=0L
FOR i=0L, (SIZE(struc))(1)-1 DO BEGIN
 ;pos(i,0) = ROUND((struc(i).x/pix_sizeX + centerX)/FLOAT(reb))
 ;pos(i,1) = ROUND((struc(i).y/pix_sizeY + centerY)/FLOAT(reb))
 pos(i,0) = FIX((struc(i).x/pix_sizeX + centerX)/FLOAT(reb))
 pos(i,1) = FIX((struc(i).y/pix_sizeY + centerY)/FLOAT(reb))

 IF KEYWORD_SET(print) THEN BEGIN
  PRINT,'X position [pixels] :', pos(i,0)
  PRINT,'Y position [pixels] :', pos(i,1)
 ENDIF

 IF KEYWORD_SET(draw) THEN BEGIN
  ;lower_x = pos(i,0) - draw/2.
  ;upper_x = pos(i,0) + draw/2. 
  ;lower_y = pos(i,1) - draw/2.
  ;upper_y = pos(i,1) + draw/2. 

  lower_x = pos(i,0) - FIX(par.boxsize.x/2.)/FLOAT(reb)
  upper_x = pos(i,0) + FIX(par.boxsize.x/2.)/FLOAT(reb)
  lower_y = pos(i,1) - FIX(par.boxsize.y/2.)/FLOAT(reb)
  upper_y = pos(i,1) + FIX(par.boxsize.y/2.)/FLOAT(reb)

  IF KEYWORD_SET(color) THEN BEGIN
   PLOTS,[lower_x,upper_x,upper_x,lower_x,lower_x],[lower_y,lower_y,upper_y,upper_y,lower_y],/DEVICE,COLOR=!D.N_COLORS-color
  ENDIF $
  ELSE PLOTS,[lower_x,upper_x,upper_x,lower_x,lower_x],[lower_y,lower_y,upper_y,upper_y,lower_y],/DEVICE,COLOR=!D.N_COLORS-1

 ENDIF


 IF KEYWORD_SET(region) THEN BEGIN
  border = LONARR(2,ct_border+1)
  FOR loc_i=0,ct_border-1 DO BEGIN
   border(0,loc_i) = pos(i,0)+FIX((FLOAT(xy_border2(loc_i)) - par.boxsize.x/2)/FLOAT(reb))
   border(1,loc_i) = pos(i,1)+FIX((IMAGINARY(xy_border2(loc_i)) - par.boxsize.y/2)/FLOAT(reb))
  ENDFOR
  border(*,ct_border) = border(*,0) 
 
  IF KEYWORD_SET(reg_color) THEN BEGIN
   PLOTS,border(0,*),border(1,*),/DEVICE,COLOR=!D.N_COLORS-reg_color
  ENDIF $
  ELSE PLOTS,border(0,*),border(1,*),/DEVICE,COLOR=!D.N_COLORS-1

 ENDIF



ENDFOR

RETURN,pos
END








