function MERGE_INTEG, integ1,integ2
;+
; NAME:
;	MERGE_INTEG
;
; PURPOSE:
;
;	Exclusive union between the different input structures
;	obtained with the idl integration package  (takes only once the 
;	spots which may be represented twice or more)
;
; CATEGORY:
;	Structure managing
;
; CALLING SEQUENCE:
;	UnionInteg = MERGE_INTEG(integ1,integ2) ;
;
; INPUTS:
;	integ1,2 : the structures to process
;
; OUTPUTS:
;	the union between the input structures
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;
; PROCEDURE:
;	Straightforward
;
; MODIFICATION HISTORY:
;	D.Bourgeois, February 95.
;-

;on_error,2                              ;Return to caller if an error occurs

one_refl=integ1(0)

;produce the right number of reflections
size1 = (SIZE(integ1))(1)
size2 = (SIZE(integ2))(1)

sizetot = size1 + size2

final = REPLICATE(one_refl,sizetot)

;fill the first half
final(0:size1-1)=integ1(*)
j=size1


;look at the reflexions unique to integ2
dummy=INTERSEC_TU(integ1,integ2,/SEP_UNIQUE,un2=un2)
IF (SIZE(dummy))(0) EQ 0 THEN un2=integ2

IF N_ELEMENTS(un2) GT 0 THEN BEGIN
 size_unique = (SIZE(un2))(1)

 ;fill the second half : check the intersection between integ1 and integ2
 ;FOR i=0,size_unique-1 DO BEGIN
 ;index = WHERE(final(0:size1-1).m(0) EQ integ2(i).m(0) AND final(0:size1-1).m(1) EQ integ2(i).m(1) AND final(0:size1-1).m(2) EQ integ2(i).m(2),count)
 ;IF count EQ 0 THEN BEGIN
   final(size1:size1+size_unique-1).m = un2(*).m
   final(size1:size1+size_unique-1).x = un2(*).x
   final(size1:size1+size_unique-1).y = un2(*).y
   final(size1:size1+size_unique-1).xpix = un2(*).xpix
   final(size1:size1+size_unique-1).ypix = un2(*).ypix
   final(size1:size1+size_unique-1).partiality = un2(*).partiality
   final(size1:size1+size_unique-1).lp = un2(*).lp
   final(size1:size1+size_unique-1).cosine = un2(*).cosine
   final(size1:size1+size_unique-1).chisquare = un2(*).chisquare
   final(size1:size1+size_unique-1).strength = un2(*).strength
   final(size1:size1+size_unique-1).par1 = un2(*).par1
   final(size1:size1+size_unique-1).par2 = un2(*).par2
   final(size1:size1+size_unique-1).l = un2(*).l
   final(size1:size1+size_unique-1).mul = un2(*).mul
   final(size1:size1+size_unique-1).nodal = un2(*).nodal
   final(size1:size1+size_unique-1).ovlp = un2(*).ovlp
   final(size1:size1+size_unique-1).id = un2(*).id
   final(size1:size1+size_unique-1).connect = un2(*).connect
   final(size1:size1+size_unique-1).close = un2(*).close
   final(size1:size1+size_unique-1).m2 = un2(*).m2
   final(size1:size1+size_unique-1).nidx = un2(*).nidx
   final(size1:size1+size_unique-1).l2 = un2(*).l2
   final(size1:size1+size_unique-1).phi = un2(*).phi
   final(size1:size1+size_unique-1).ipoint = un2(*).ipoint
   final(size1:size1+size_unique-1).dminth = un2(*).dminth
   final(size1:size1+size_unique-1).intb = un2(*).intb
   final(size1:size1+size_unique-1).isigb = un2(*).isigb
   final(size1:size1+size_unique-1).intp = un2(*).intp
   final(size1:size1+size_unique-1).isigp = un2(*).isigp
   final(size1:size1+size_unique-1).tth = un2(*).tth
   final(size1:size1+size_unique-1).res = un2(*).res
   final(size1:size1+size_unique-1).flag = 4
   final(size1:size1+size_unique-1).gfit = 1
   ;j = j + 1
 ;ENDIF
;ENDFOR

 PRINT,'Total number of reflections',size1+size_unique
 RETURN,final(0:size1+size_unique-1)
ENDIF ELSE BEGIN
 PRINT,'Total number of reflections',size1
 RETURN,final(0:size1-1)
ENDELSE
END

