function GET_XREF_PROF1, image,reb,ref,par,max_number_peaks,min_sob,min_ref_peaks,all_ref=all_ref,use_partials=use_partials,show=show,$
	bad_shift_count=bad_shift_count,bad_fwhm_count=bad_fwhm_count,spots_bad_fwhm=spots_bad_fwhm,spots_bad_shift=spots_bad_shift,$
	study_win=study_win,main_win=main_win

;+
; NAME:
;	GET_XREF_PROF1
;
; PURPOSE:
;	Select reference peaks for profile fitted PROW integration software.
;	A maximum of number_peaks peaks are selected, which all show a 
;	minimum peak_value/background equal to min_sob. These peaks are
;	carefully checked for FWHM, dead pixels and spikes or spurious
;	peaks, and possibly for partiality.
;
; CATEGORY:
;	Mono processing.
;
; CALLING SEQUENCE:
;	Reference_profiles = GET_XREF_PROF1(image,reb,ref,par,number_peaks,
;		min_sob,/show,all_ref=all_ref,/use_partials,study_win=study_win,main_win=main_win)
;
; INPUTS:
;	image : the original image
;	reb : the rebinning factor
;	ref : the reflexion list, corrected for positions, produced by the LOC_REFINE[1-2] routines.
;	par : the parameters of the experiment
;	max_number_peaks : the maximum number of peaks to select
;	min_sob : the minimum peak_value to background ratio to select a peak
;	show : keyword set if the reference profile is to be visualized
;	all_ref : all the reflexion, not just the candidates for reference spots. Used when there is the need to 
;		check for overlapped spots.
;	use_partials : set this keyword if the partially recorded reflections
;		are to be used for reference profiles.
;	study_win : window id of the window displaying surface plots, contour ... in debug modes
;	main_win : window id of the main window displaying the image
;
; OUTPUTS:
;	reference_profile : a structure containing the reference profiles and
;			their parameters.
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;	None.
;
; PROCEDURE:
;	Straightforward.	
;
; MODIFICATION HISTORY:
;	D.Bourgeois, February 1995.
;-

;position of center of image and pixel size [micrometers]
centerX = par.cenx - 1
centerY = par.ceny - 1
scaleY = par.yscale
pix_size = par.raster
pix_sizeX = 0.001*pix_size
pix_sizeY = 0.001*pix_size/scaleY


;select only fullies if needed
IF NOT KEYWORD_SET(use_partials) THEN BEGIN
 w_fullies=WHERE(ref.partiality EQ 0,ct_fullies)
 PRINT,'Number of fullies : ',ct_fullies,' ie : ',100*ct_fullies/(SIZE(ref))(1),' %'
 IF ct_fullies GT 0 THEN $
  sort_ref=ref(w_fullies) ELSE BEGIN
   PRINT,'There are no fullies, will use the partials to build reference profiles ...' 
   sort_ref=ref
   ct_fullies=(SIZE(ref))(1)
  ENDELSE
ENDIF ELSE BEGIN 
 sort_ref=ref
 ct_fullies = (SIZE(ref))(1)
ENDELSE

;check if all_ref (all reflexions) have been loaded.
IF N_ELEMENTS(all_ref) EQ 0 THEN all_ref=ref

all_index=0
all_bad_fwhm_index = 0
all_bad_shift_index = 0

PRINT,STRCOMPRESS('Total minimum number of reference peaks set to : '+STRING(min_ref_peaks))

;this is the minimum number of reference peaks in each sector
sec_min_ref_peaks=min_ref_peaks/FLOAT(par.n_sectors)

;Run the selection criterium for each sector
FOR sec_i=0,par.n_sectors-1 DO BEGIN

 bad_shift_count=0
 bad_fwhm_count=0

 w=WHERE(sort_ref.sector EQ (sec_i+1),n_ref) 
 PRINT,'&&&&&&&&&&&&&&&&&&&&'
 PRINT,STRCOMPRESS('Sector # : '+STRING(sec_i+1))
 PRINT,STRCOMPRESS('Number of preselected spots : '+ STRING(n_ref))

 IF n_ref GT 0 THEN sec_ref = sort_ref(w) ELSE GOTO,next_sector

 ;sort the spots according to peak maximum.
  sec_ref = (sec_ref(REVERSE(SORT(sec_ref.intp(0)))))(0:(((3./FLOAT(par.n_sectors))*max_number_peaks-1)<((SIZE(sec_ref))(1)-1)))

 ;initialize some parameters.
 iteration=0  ; iteration number
 number_spots=-1L ; number of satisfactory spots (having passed the filters)
 old_number_spots=-1L ; number of satisfactory spots in previous cycle
 number_ini_spots=0 ; number of spots satisfying the I/SIGI criterium (before filters)
 min_sob2=1.05*min_sob
 sec2_min_ref_peaks=sec_min_ref_peaks
 constraints=1. ; constraints coefficient for filters

 REPEAT BEGIN
  min_sob2=min_sob2/1.05

  IF (min_sob2 le 0.1) THEN MESSAGE, 'Reduce minimum number of reference peaks!' 

  ;we select for the peaks of sufficient signal to background ratio
  possible_ini_index = WHERE(sec_ref.intp(0)/sec_ref.bc_coeff(2) GT min_sob2,number_ini_spots)
  IF number_ini_spots GT 0 THEN $
   poss_ini_ref = sec_ref(possible_ini_index)

 ENDREP UNTIL  (number_ini_spots GE (1.25*sec_min_ref_peaks < n_ref/1.5))

 PRINT,STRCOMPRESS('I/SIGI limit set to : '+ STRING(min_sob2))

 REPEAT BEGIN
 ; PRINT,'***Number of selectable spots :',number_spots
 ; PRINT,'***Old number of selectable spots :',old_number_spots
   IF iteration EQ 0 THEN $
    PRINT,STRCOMPRESS('Initial number of spots with good I/SIGI :'+STRING(number_ini_spots))
 ; PRINT,'***Number of iteration :',iteration

 reduce_constraints :

  IF ((number_ini_spots GE 2*number_spots) AND (iteration GE 1)) THEN BEGIN
   ;only release constraints on the filters because the number of spots with good I/sigI is enough.
   constraints=0.8*constraints
   PRINT,STRCOMPRESS('Reducing constraints to : '+ STRING(constraints))
   sec2_min_ref_peaks=FIX(sec2_min_ref_peaks/1.2)
   PRINT,STRCOMPRESS('Minimum number of reference peaks reduced to : '+STRING(sec2_min_ref_peaks))
  ENDIF 

  IF ((number_ini_spots LT 2*number_spots) AND (iteration GE 1)) THEN BEGIN

   ;only release constraints on the sob because the number of spots with good I/sigI is too low.
   min_sob2=min_sob2/1.1

   IF (min_sob2 le 0.1) THEN MESSAGE, 'Can not find reference peaks!' 
   PRINT,STRCOMPRESS('Reducing I/SIGI limit to : '+ STRING(min_sob2))

   ;we select for the peaks of sufficient signal to background ratio
   possible_ini_index = WHERE(sec_ref.intp(0)/sec_ref.bc_coeff(2) GT min_sob2)

   IF (SIZE(possible_ini_index))(0) GT 0 THEN $
    poss_ini_ref = sec_ref(possible_ini_index) ELSE MESSAGE,'Error, no spot selected ... ' 

   ;the new number of initial potential spots is :
   number_ini_spots = (SIZE(possible_ini_index))(1)
   PRINT,STRCOMPRESS('Number of peaks with sufficient I/Sig(I) :'+STRING(number_ini_spots))

  ENDIF


;   IF ((old_number_spots GE number_ini_spots-1) AND (iteration GE 1)) THEN BEGIN
   IF ((old_number_spots GE number_spots) AND (iteration GE 1)) THEN BEGIN
    ;in this case we havent selected any more good spots !
    PRINT,'Too few good spots ...'
    PRINT,STRCOMPRESS('Kept number of reference peaks : '+STRING(number_spots))
    GOTO,sector_ok
   ENDIF

  ;save old number of spots 
  ;old_number_spots = number_ini_spots ; that is wrong !
  old_number_spots = number_spots

  ;*****
  ;get all spots of interest  (as structures) :
  ;*****
  
  IF ((SIZE(ini_denzo_spots))(0) EQ 0) OR (iteration EQ 0) THEN $
   ini_spots = GET_DENZO_SPOTS(poss_ini_ref,image,reb,par) $
  ELSE $
   ini_spots = GET_DENZO_SPOTS(poss_ini_ref,image,reb,par,old_spots=ini_denzo_spots)

  ini_denzo_spots=0 ; reinitialize the ini_denzo_spots

  IF KEYWORD_SET(show) THEN BEGIN ;show
   IF N_ELEMENTS(main_win) THEN BEGIN
	IF main_win EQ -1 THEN main_win = !D.WINDOW
   ENDIF ELSE main_win = !D.WINDOW

   IF N_ELEMENTS(study_win) THEN BEGIN
    IF study_win EQ -1 THEN BEGIN 
     WIN,512,512,/FREE,TITLE='Debug Window'
     study_win = !D.WINDOW
    ENDIF
   ENDIF ELSE BEGIN
    WIN,512,512,/FREE,TITLE='Debug Window'
    study_win = !D.WINDOW
   ENDELSE
  ENDIF ;show

  ;*****
  ;now apply all filters
  ;*****
  filters :

  ;******
  ;remove spots with bad background 
  ;******


  IF MAX(ini_spots.flag) NE 0 THEN BEGIN
   possible_index = WHERE(ini_spots.flag EQ 0,count)
   IF count EQ 0 THEN BEGIN
    PRINT,'Not a single good reference spot [BACKGROUND] !'
    number_spots=0
    iteration=iteration+1
    GOTO,reduce_constraints
;   GOTO,next_sector
   ENDIF
   PRINT,'Number of spots rejected over bad background :', (SIZE(ini_spots))(1) - (SIZE(possible_index))(1)
   spots = ini_spots(possible_index)
  ENDIF ELSE BEGIN
   spots=ini_spots
   PRINT,STRCOMPRESS('Number of spots rejected over bad background :'+STRING(0))
  ENDELSE

  ;the number of potential spots is now:
  number_spots = (SIZE(spots))(1)

  ;******
  ;remove spots which may be overlapped if some lose criteria was applied for the field .ovlp2
  ; only necessary to do this if there is an "overall_region" covering potential strongly overlapped spots.
  ; If there is no overall_region, then the spike search will take care of this.
  ;******

  IF MAX(par.overall_region) NE 0 THEN BEGIN
   IF MAX(spots.ovlp) NE 0 THEN BEGIN
    good_flag=BYTARR(number_spots)
    ;give a minimum acceptable ratio between peak values for overlapped peaks
    min_ratio=constraints*10.
    w_ovlp = WHERE(spots.ovlp NE 0,count)
    ;look if the spots which are supposingly overlapped are actually so
    FOR  i=0,count-1 DO BEGIN
     ;reset the ratio
     ratio=10000000.
     ;go over all connected spots
     FOR j=0,spots(w_ovlp(i)).ovlp-1 DO BEGIN
      ovlp_ref = WHERE(all_ref.id EQ spots(w_ovlp(i)).connect(j),ct_ovlp)
      IF ct_ovlp NE 1 THEN MESSAGE,'Impossible to find a spot overlapped to this potential reference spot !'
      ;look at the ratio between peak values 
      peak_ratio = (spots(w_ovlp(i)).intp(0)-spots(w_ovlp(i)).bc_coeff(2))/(all_ref(ovlp_ref).intp(0)-all_ref(ovlp_ref).bc_coeff(2))
      ;PRINT,'X/Y of the two peaks : ',spots(w_ovlp(i)).x,spots(w_ovlp(i)).y,all_ref(ovlp_ref).x,all_ref(ovlp_ref).y
      ;PRINT,'Hights of the two peak : ', spots(w_ovlp(i)).intp(0)-spots(w_ovlp(i)).bc_coeff(2), all_ref(ovlp_ref).intp(0)-all_ref(ovlp_ref).bc_coeff(2)
      ;PRINT,'Ratio between the two peak : ', peak_ratio
      ratio = ratio < ABS(peak_ratio)
     ENDFOR
     ;PRINT,'Minimum ratio obtained is : ',ratio
     IF ratio LT min_ratio THEN good_flag(w_ovlp(i))=1 


     ; try to see if there is a valley between the peak and the neighbouring overlapping peaks
     ; 1 : get the cutoff level and find the region of integration with the /fine_search procedure
     ; 2 : check wether the overlapping peaks belong to this region of integration
     ; only do that for Laue mode

     IF par.mode EQ 'laue' THEN BEGIN
     IF good_flag(w_ovlp(i)) EQ 1 THEN BEGIN

   
    peak = spots(w_ovlp(i)).sp - spots(w_ovlp(i)).bc
    ;here "overall_region" should be applied
    peak(par.overall_region)=0

    ;get the cutoff level. Constraints can not be applied here because the same cutoff will be applied during box integration 
    cutoff = GET_BOXLEVEL(peak,spots(w_ovlp(i)).bc_coeff(1),spots(w_ovlp(i)).bc_coeff(2),par.dark_current)

    ;get the best contour for integration
    region = GET_BOXREG(peak,cutoff,par.boxsize,/FINE_SEARCH)



    ;check wether overlapped spots fall in this region
    FOR j=0,spots(w_ovlp(i)).ovlp-1 DO BEGIN
      ovlp_ref = WHERE(all_ref.id EQ spots(w_ovlp(i)).connect(j),ct_ovlp)
      IF ct_ovlp NE 1 THEN MESSAGE,'Impossible to find a spot overlapped to this potential reference spot !'
      ;check if the 9 pixel around the predicted position of ovlp_ref belong to region.
      ;position of the spot of interest
      xpos = FIX(spots(w_ovlp(i)).x/pix_sizeX+centerX)
      ypos = FIX(spots(w_ovlp(i)).y/pix_sizeY+centerY)
      ;position of the overlapped spot
      xpos2 = FIX(all_ref(ovlp_ref).x/pix_sizeX+centerX)
      ypos2 = FIX(all_ref(ovlp_ref).y/pix_sizeY+centerY)
      ;position of the overlapped spot in the box of the spot of interest
      xpos22 = FIX(par.boxsize.x/2.) + xpos2-xpos
      ypos22 = FIX(par.boxsize.y/2.) + ypos2-ypos
      ;do not accept the spot of interest by default
      accept_spot = 0
      FOR loc_x1=-1,1 DO BEGIN
       FOR loc_y1=-1,1 DO BEGIN
	curr_x = xpos22+loc_x1 & curr_y = ypos22+loc_y1
        IF ((curr_x LT 0) OR (curr_x GE par.boxsize.x)) AND ((curr_y LT 0) OR (curr_y GE par.boxsize.y)) THEN BEGIN
	 ;in this case the overlapped spot is out of the box delineating the spot of interest, so it's OK
	 accept_spot=accept_spot+1
	ENDIF ELSE BEGIN
	 curr_index = curr_x + par.boxsize.x*curr_y
	 w_region = WHERE(region EQ curr_index,ct_region)
	 IF ct_region EQ 0 THEN accept_spot=accept_spot+1
	ENDELSE
       ENDFOR
      ENDFOR
     ENDFOR
      ;it's ok if accept_spot = 9 
      IF accept_spot EQ 9*spots(w_ovlp(i)).ovlp THEN good_flag(w_ovlp(i))=0

;check=image(xpos - 2*FIX(par.boxsize.x/2.):xpos + 2*FIX(par.boxsize.x/2.) ,ypos - 2*FIX(par.boxsize.y/2.):ypos + 2*FIX(par.boxsize.y/2.))
;print,'# of overlaps ',spots(w_ovlp(i)).ovlp
;print,'accepted:',accept_spot
;print,'good ?',good_flag(w_ovlp(i))
;surface,check
;stop

;peak2=peak & peak2(*)=0 & peak2(region)=peak(region) & surface,peak2
     ENDIF
    ENDIF ; laue mode
    ENDFOR
    possible_index = WHERE(good_flag EQ 0,number_spots)
    IF number_spots EQ 0 THEN BEGIN
     PRINT,'Not a single good reference spot [TOO STRONG NEIGHBOUR PEAKS] !'
     number_spots=0
     iteration=iteration+1
     GOTO,reduce_constraints
    ENDIF
    PRINT,STRCOMPRESS('Number of spots rejected for being flanged by overlapping spots :'+ STRING((SIZE(spots))(1) - number_spots))
    spots = spots(possible_index)
   ENDIF
  ENDIF 


  ;******
  ;remove any spurious peak or spike
  ;******
  number_spike = 0
  number_dead = 0

  FOR i=0,number_spots-1 DO BEGIN ;go through all spots
   IF spots(i).spike_tested GE 0 THEN BEGIN ; if the spot was not tested before or it was bad.
    peak = spots(i).sp - spots(i).bc

    ;here "overall_region" should possibly be applied
    IF MAX(par.overall_region) NE 0 THEN peak(par.overall_region)=0

    ;here "regions" should be applied
    ;peak(*par.regions(sec_i))=0

    ;get the cutoff level
    cutoff = (1/constraints)*GET_BOXLEVEL(peak,spots(i).bc_coeff(1),spots(i).bc_coeff(2),par.dark_current)

    IF par.mode EQ 'laue' THEN BEGIN
     ;get the best contour for integration
     region = GET_BOXREG(peak,cutoff,par.boxsize,/FINE_SEARCH)
     peak2=peak & peak2(*)=0 & peak2(region) = peak(region) & peak=peak2
    ENDIF

    ;is there a spike or a dead pixel ?
    spike = GET_SPIKE(peak,cutoff,par.boxsize,show=show)
    number_spike = number_spike + spike
    IF spike EQ 0 THEN BEGIN ; if no spike
     dead_pix = GET_DEADPIX(peak,cutoff,par.boxsize,show=show)
     number_dead = number_dead + dead_pix
     IF dead_pix EQ 1 THEN spots(i).spike_tested=2 ELSE spots(i).spike_tested=-1
    ENDIF ELSE BEGIN ; there was a spike
	spots(i).spike_tested=1
	dead_pix = 0
    ENDELSE
   ENDIF ELSE BEGIN ; the spot was tested before and was OK
    spike=0
    dead_pix=0
   ENDELSE

   IF KEYWORD_SET(show) THEN BEGIN
    IF i ge 0 THEN BEGIN
     PRINT,'Spot number :',i
     PRINT,'Miller indices :',spots(i).m
     WSET,main_win
     dummy = PIXLAUE2(spots(i),reb,image,par,draw=8,color=3)
     WSET,study_win
     PRINT,'Original peak'
     SURFACE,peak
     OK=''
     PRINT,'OK ? [Y/N]'
     READ,OK
    ENDIF
   ENDIF

  ENDFOR ; going through all spots

  possible_index = WHERE(spots.spike_tested EQ -1,count)
  ini_denzo_spots = spots 
  IF count GT 0 THEN BEGIN
   spots = spots(possible_index)
   number_spots=(SIZE(spots))(1)
  ENDIF ELSE BEGIN 
    PRINT,'Not a single good reference spot [SPIKE and DEAD PIXELS] !'
    number_spots=0
    iteration=iteration+1
    GOTO,reduce_constraints
  ENDELSE

  PRINT,STRCOMPRESS('Number of spots rejected for spikes or too uneven background :'+STRING(number_spike))
  PRINT,STRCOMPRESS('Number of spots rejected for dead pixels :'+STRING(number_dead))

   ;******
  ;remove any bad FWHM
  ;******
  ;selection of good reference spots : all spots are checked for
  ;FWHM and then compared with the global mean profile and checked 
  ;for deviation :
  ;If only one spot is selected, the FWHM should be >= 1 pixel

  IF number_spots GT 1 THEN BEGIN
   sigma = STDEV(spots.fwhm,mean) 
   possible_index = WHERE((spots.fwhm - mean)^2 LE (1/constraints)*5.0*sigma^2,count)
   bad_fwhm_index = WHERE((spots.fwhm - mean)^2 GT (1/constraints)*5.0*sigma^2,bad_fwhm_count)
  ENDIF ELSE BEGIN 
   IF spots(0).fwhm LE par.raster*0.001 THEN BEGIN
    ;this must be a spike !
    count=0 & bad_fwhm_index=0 & bad_fwhm_count=1
   ENDIF 
   ;sigma = 1 & mean=spots(0).fwhm
  ENDELSE

  IF bad_fwhm_count GT 0 THEN spots_bad_fwhm = spots(bad_fwhm_index)

  IF count EQ 0 THEN BEGIN
   PRINT,'Not a single good reference spot [FWHM] !'
   IF bad_fwhm_count GT 0 THEN spots_bad_fwhm = spots(bad_fwhm_index)
   iteration=iteration+1
   number_spots=0
   GOTO,reduce_constraints
  ENDIF
  spots = spots(possible_index)

  PRINT,STRCOMPRESS('Number of reference peaks rejected from bad FWHM :'+STRING(number_spots-count))

  number_spots=(SIZE(spots))(1)


  ;******
  ;remove spots which are shifted
  ;******

  bs=par.boxsize
  bsx2 = FIX(par.boxsize.x/2.)
  bsy2 = FIX(par.boxsize.y/2.)

  FOR i=0,number_spots-1 DO spots(i).intp(1)=MAX(spots(i).sp(bsx2-bsx2/2:bsx2+bsx2/2,bsy2-bsy2/2:bsy2+bsy2/2))

  possible_index = WHERE( $
  spots.sp(FIX(bs.x*bsy2+bsx2)) EQ LONG(spots.intp(1)) OR $
  spots.sp(FIX(bs.x*bsy2+bsx2-1)) EQ LONG(spots.intp(1)) OR $
  spots.sp(FIX(bs.x*bsy2+bsx2+1)) EQ LONG(spots.intp(1)) OR $
  spots.sp(FIX(bs.x*(bsy2-1)+bsx2)) EQ LONG(spots.intp(1)) OR $
  spots.sp(FIX(bs.x*(bsy2-1)+bsx2-1)) EQ LONG(spots.intp(1)) OR $
  spots.sp(FIX(bs.x*(bsy2-1)+bsx2+1)) EQ LONG(spots.intp(1)) OR $
  spots.sp(FIX(bs.x*(bsy2+1)+bsx2)) EQ LONG(spots.intp(1)) OR $
  spots.sp(FIX(bs.x*(bsy2+1)+bsx2-1)) EQ LONG(spots.intp(1)) OR $
  spots.sp(FIX(bs.x*(bsy2+1)+bsx2+1)) EQ LONG(spots.intp(1)) $
  ,count)

  bad_shift_index = WHERE( $
  spots.sp(FIX(bs.x*bsy2+bsx2)) NE LONG(spots.intp(1)) AND $
  spots.sp(FIX(bs.x*bsy2+bsx2-1)) NE LONG(spots.intp(1)) AND $
  spots.sp(FIX(bs.x*bsy2+bsx2+1)) NE LONG(spots.intp(1)) AND $
  spots.sp(FIX(bs.x*(bsy2-1)+bsx2)) NE LONG(spots.intp(1)) AND $
  spots.sp(FIX(bs.x*(bsy2-1)+bsx2-1)) NE LONG(spots.intp(1)) AND $
  spots.sp(FIX(bs.x*(bsy2-1)+bsx2+1)) NE LONG(spots.intp(1)) AND $
  spots.sp(FIX(bs.x*(bsy2+1)+bsx2)) NE LONG(spots.intp(1)) AND $
  spots.sp(FIX(bs.x*(bsy2+1)+bsx2-1)) NE LONG(spots.intp(1)) AND $
  spots.sp(FIX(bs.x*(bsy2+1)+bsx2+1)) NE LONG(spots.intp(1)) $
  ,bad_shift_count)

  IF count EQ 0 THEN BEGIN
   PRINT,'Not a single good reference spot [SHIFT] !'
   iteration=iteration+1
   bad_shift_count=number_spots
   IF bad_shift_count GT 0 THEN spots_bad_shift = spots(bad_shift_index)
   number_spots=0
   GOTO,reduce_constraints
  ENDIF

  PRINT,STRCOMPRESS('Number of spots rejected because too large shift :'+ STRING((SIZE(spots))(1) - (SIZE(possible_index))(1)))

  IF bad_shift_count GT 0 THEN spots_bad_shift = spots(bad_shift_index)

  spots = spots(possible_index)

  ;the number of potential spots is now:
  number_spots = (SIZE(spots))(1)

  ;******
  ;end of filtering
  ;******

  PRINT,STRCOMPRESS('Number of selected reference spots in this cycle :'+STRING((SIZE(spots))(1)))

  number_spots = (SIZE(spots))(1)
  iteration=iteration+1

 ENDREP UNTIL ((SIZE(spots))(1) GE sec2_min_ref_peaks)


 sector_ok :
  ;prepare final structure of reference spots



 ;******
  ;select optimal restrained region in the sector
  ;******

;   tot_spot=LONARR(par.boxsize.x,par.boxsize.y)
   ;get the average spot

;   FOR i=0,(SIZE(spots))(1)-1 DO tot_spot=tot_spot + spots(i).sp - spots(i).bc

   ;SURFACE,tot_spot
   ;get the optimal region, corresponding to approximately the 0.1% level of this average spot.
   ;The area for 5.0% of a gaussian corresponds to twice the one for 47 % [check ?]
   ;The area for 2.0% of a gaussian corresponds to twice the one for 38 % [check ?]
   ;The area for 1.0% of a gaussian corresponds to twice the one for 32 % [check ?]
   ;The area for 0.5% of a gaussian corresponds to twice the one for 27 % [check ?]
   ;The area for 0.25% of a gaussian corresponds to twice the one for 22 % [check ?]
   ;The area for 0.1% of a gaussian corresponds to twice the one for 18 % [check ?]
   ;we get the correspondance by a linear polynom fit.
   ;pol = [14.7148,35.3438,-26.2188,9.25000,-1.02930]
   ;rest_area = GET_BOXREG(tot_spot,ROUND(POLY(par.region_level,pol)),par.boxsize,/FINE_SEARCH)

;   max_tot_spot=MAX(tot_spot)
;   rest_area = SEARCH2D(tot_spot,par.boxsize.x/2,par.boxsize.y/2,max_tot_spot*par.region_level/100.,max_tot_spot)
;   rest_area=GET_ENLARGED_REGION(rest_area,par.boxsize.x,par.boxsize.y,extend=1)

;   tmp_spot=LONARR(par.boxsize.x,par.boxsize.y)
;   tmp_spot(rest_area)=1
;   rest_area=WHERE(tmp_spot EQ 0,ct_rest)
   ;this is unlikely, but if it happens, just remove the four corners
;   IF ct_rest EQ 0 THEN rest_area=[0,par.boxsize.x-1,(par.boxsize.y-1)*(par.boxsize.x),(par.boxsize.x*par.boxsize.y)-1]

   ;SURFACE,tot_spot
   ;trunc_spot=tot_spot
   ;trunc_spot(*)=0
   ;trunc_spot(rest_area)=tot_spot(rest_area)
   ;SURFACE,trunc_spot,COLOR=0.8*!D.N_COLORS  
   ;ok='ok'
   ;read,'ok?',ok

   ;now load the restrained region
;   PTR_FREE,par.regions(sec_i)
;   par.regions(sec_i)=PTR_NEW(rest_area)

   ;dummy_spot=LONARR(par.boxsize.x,par.boxsize.y)
   ;dummy_spot(*par.regions(sec_i))=1
   ;SURFACE,dummy_spot

 ; incorporate newly selected spots

  IF (N_ELEMENTS(final_ref_spots) EQ 0) AND ((SIZE(spots))(0) EQ 1) THEN BEGIN
   final_ref_spots = REPLICATE(spots(0),5*max_number_peaks)
   final_bad_shift_spots = final_ref_spots
   final_bad_fwhm_spots = final_ref_spots
  ENDIF

  IF number_spots GT 0 THEN BEGIN ;final_ref_spots(all_index:all_index+number_spots-1)=spots
   FOR loc_i = 0, n_tags(spots(0))-1 DO BEGIN
    result=EXECUTE('final_ref_spots(all_index:all_index+number_spots-1).'+(tag_names(spots(0)))(loc_i)+' = spots.'+(tag_names(spots(0)))(loc_i))
   ENDFOR
  ENDIF

  IF bad_shift_count GT 0 THEN BEGIN ;final_bad_shift_spots(all_bad_shift_index:all_bad_shift_index+bad_shift_count-1)=spots_bad_shift
   FOR loc_i = 0, n_tags(spots(0))-1 DO BEGIN
    result=EXECUTE('final_bad_shift_spots(all_bad_shift_index:all_bad_shift_index+bad_shift_count-1).'+(tag_names(spots(0)))(loc_i)+' = spots_bad_shift.'+(tag_names(spots(0)))(loc_i))
   ENDFOR
  ENDIF 

  IF bad_fwhm_count GT 0 THEN BEGIN ;final_bad_fwhm_spots(all_bad_fwhm_index:all_bad_fwhm_index+bad_fwhm_count-1)=spots_bad_fwhm
   FOR loc_i = 0, n_tags(spots(0))-1 DO BEGIN
    result=EXECUTE('final_bad_fwhm_spots(all_bad_fwhm_index:all_bad_fwhm_index+bad_fwhm_count-1).'+(tag_names(spots(0)))(loc_i)+' = spots_bad_fwhm.'+(tag_names(spots(0)))(loc_i))
   ENDFOR
  ENDIF 


  all_index=all_index+number_spots
  all_bad_fwhm_index = all_bad_fwhm_index + bad_fwhm_count
  all_bad_shift_index = all_bad_shift_index + bad_shift_count
  PRINT,STRCOMPRESS('Final number of reference spots added : '+STRING(number_spots))
  PRINT,STRCOMPRESS('Final number of bad shift added : '+STRING(bad_shift_count))
  PRINT,STRCOMPRESS('Final number of bad fwhm added : '+STRING(bad_fwhm_count))

 IF KEYWORD_SET(SHOW) THEN BEGIN ;begin show
  FOR i=0,number_spots-1 DO BEGIN
   dum = spots(i).sp - spots(i).bc
   PRINT,'PosMax :',WHERESUB(WHERE(dum EQ MAX(dum)),dum)
  ENDFOR

  FOR i=0,(SIZE(spots))(1)-1 DO BEGIN
   WSET,main_win
   dummy = PIXLAUE2(spots(i),reb,image,par,draw=8,color=3)
   WSET,study_win
  ENDFOR

 ENDIF ; show
 next_sector : 
ENDFOR ; FOR each sector

IF all_index EQ 0 THEN MESSAGE,'Not a single reference spot could be selected !'

IF all_bad_fwhm_index GT 0 THEN BEGIN
 spots_bad_fwhm = final_bad_fwhm_spots(0:all_bad_fwhm_index-1)
 bad_fwhm_count = (SIZE(spots_bad_fwhm))(1)
ENDIF

IF all_bad_shift_index GT 0 THEN BEGIN
 spots_bad_shift = final_bad_shift_spots(0:all_bad_shift_index-1)
 bad_shift_count = (SIZE(spots_bad_shift))(1)
ENDIF

PRINT,'&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&'
PRINT,STRCOMPRESS('Total number of new reference spots : '+STRING(all_index))
PRINT,'&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&'
PRINT,STRCOMPRESS('Total number of shifted spots : '+STRING(bad_shift_count))
PRINT,STRCOMPRESS('Total number of bad FWHM spots : '+STRING(bad_fwhm_count))

IF N_ELEMENTS(study_win) NE 0 THEN BEGIN
 WSET,study_win
 WDELETE
 WSET,main_win
ENDIF

;tot_spot=LONARR(par.boxsize.x,par.boxsize.y)
;FOR i=0,all_index-1 DO tot_spot=tot_spot + final_ref_spots(i).sp - final_ref_spots(i).bc
;max_tot_spot=MAX(tot_spot)
;overall_area = SEARCH2D(tot_spot,par.boxsize.x/2,par.boxsize.y/2,max_tot_spot*par.region_level/100.,max_tot_spot)
;overall_area=GET_ENLARGED_REGION(overall_area,par.boxsize.x,par.boxsize.y,extend=2)
;tmp_spot=LONARR(par.boxsize.x,par.boxsize.y)
;tmp_spot(overall_area)=1
;overall_area=WHERE(tmp_spot EQ 0,ct_rest)

;par = CREATE_STRUCT(par,'overall_region2',overall_area)

RETURN,final_ref_spots(0:all_index-1)
END




