function ESTIMATE_BOXSIZE,image,ref,parameters,ovlp_dist=ovlp_dist,max_number_ref=max_number_ref,r1=r1,r2=r2,$
	alpha1=alpha1,alpha2=alpha2,satvalue=satvalue,show=show,study_win=study_win,main_win=main_win,bin_fac=bin_fac,mode=mode

;+
; NAME:
;	ESTIMATE_BOXSIZE
;
; PURPOSE:
;	Estimate boxsize and overlap distance before starting a Prow integration session.
;
; CATEGORY:
;	Image processing.
;
; CALLING SEQUENCE:
;	boxsize = ESTIMATE_BOXSIZE(image,ref,parameters,[ovlp_dist=ovlp_dist],[max_number_ref=max_number_ref],$
;		[r1=r1],[r2=r2],[alpha1=alpha1],[alpha2=alpha2],[satvalue=satvalue],[show=show],$
;		[study_win=study_win],[main_win=main_win],[bin_fac=bin_fac]
;
; INPUTS:
;	image : the original image
;	parameters : the parameters of the experiment
;	show : keyword set if the reference profile is to be visualized
;	study_win : window id of the window displaying surface plots, contour ... in debug modes
;
; OUTPUTS:
;	boxsize: the suggested boxsize.
;	ovlp_dist: [optional] the suggested overlap distance.
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;	None.
;
; PROCEDURE:
;	1/ Select the spots in between r1,r2,alpha1,alpha2, in descending order of intensity.
;	2/ Remove saturated spots, spots which have a bad FWHM, spots which are shifted.
;	3/ Compute the average spot for a large boxsize (to be sure the whole spot will be included), and 
;		remove its background.
;	4/ Display this to the user.
;	5/ Estimate the number of pixels in the spot which are above noise, get a spot diameter and a cutoff
;		level.
;	6/ Choose a box size of 2 the spot diameter
;	7/ Calculate the long axis and short axis lengths with the chosen cutoff, and multiply the boxsize 
;		with the anisotropy factor.
;	8/ Repeat 7 with the final boxsize suggested.
;
; MODIFICATION HISTORY:
;	D.Bourgeois, August 2000.
;-

IF N_ELEMENTS(mode) EQ 0 THEN mode='mono'

centerX = parameters.cenx - 1
centerY = parameters.ceny - 1
scaleY = parameters.yscale
pix_size = parameters.raster
pix_sizeX = 0.001*pix_size
pix_sizeY = 0.001*pix_size/scaleY

; Pick the right area:
at = ATAN(ref.y,ref.x)*180/!Pi
sq = SQRT(ref.x^2 + ref.y^2)

x_size=(SIZE(image))(1) & y_size=(SIZE(image))(2)

IF KEYWORD_SET(show) THEN BEGIN ;show
 WSET,main_win
 LAUE_DRAW_SEC,LONARR(x_size,y_size,/NOZERO),bin_fac,parameters,alpha1,alpha2,r1,r2
ENDIF

IF alpha1 GT 180 THEN alpha1_b = alpha1 - 360 ELSE alpha1_b = alpha1 
IF alpha2 GT 180 THEN alpha2_b = alpha2 - 360 ELSE alpha2_b = alpha2

  IF alpha1_b LT alpha2_b THEN $
   w = WHERE( at LT alpha2_b AND $
		at GE alpha1_b AND $
		sq GE r1 AND $
		sq LE r2,n_ref) ELSE $
   w = WHERE( at LT alpha2_b OR $
		at GE alpha1_b AND $
		sq GE r1 AND $
		sq LE r2,n_ref)

 IF n_ref GT 0 THEN BEGIN
  sel_ref=ref(w)
 ENDIF ELSE BEGIN
  ok=DIALOG_MESSAGE('No predictions found !',/ERROR)
  GOTO,end_of_routine
 ENDELSE


;Remove saturated spots
peak_val=image(sel_ref.xpix,sel_ref.ypix)
w_ok=WHERE(peak_val LT satvalue,ct_ok)
IF ct_ok GE 1 THEN sel_ref=sel_ref(w_ok)



; Pick the right spots.
IF MAX(ref.intp(5) EQ 0) OR mode NE 'mono' THEN BEGIN
 ;then this was not loaded from DENZO, and we must assess peak values.
 peak_val=image(sel_ref.xpix,sel_ref.ypix)
 s=REVERSE(SORT(peak_val))
 sel_ref=sel_ref(s(0:(max_number_ref-1)<((SIZE(sel_ref))(1)-1)))
ENDIF ELSE BEGIN 
 ;we can use the denzo integration in this case.
 ;sort in descending order
 s=REVERSE(SORT(sel_ref.intp(5)))
 sel_ref=sel_ref(s(0:(max_number_ref-1)<((SIZE(sel_ref))(1)-1)))
ENDELSE
n_ref=(SIZE(sel_ref))(1)
PRINT,'Number of selected spots: ',n_ref


;Compute the average spot for a large boxsize of 35 pixels
 large_boxsize=35
 one_spot={x:0L,y:0L,sp:LONARR(large_boxsize,large_boxsize,/NOZERO),bc:LONARR(large_boxsize,large_boxsize,/NOZERO),fwhm:0.0,max_val:0L}
 all_spots=REPLICATE(one_spot,n_ref)
 all_spots.x = FIX(sel_ref.x/pix_sizeX+centerX)
 all_spots.y = FIX(sel_ref.y/pix_sizeY+centerY)
 all_spots.max_val=image(all_spots.x,all_spots.y)
 FOR k=0,(n_ref-1) DO BEGIN
  all_spots(k).sp = image(all_spots(k).x - FIX(large_boxsize/2.) : $
    all_spots(k).x + FIX(large_boxsize/2.) , all_spots(k).y - $
    FIX(large_boxsize/2.):all_spots(k).y + FIX(large_boxsize/2.))
  all_spots(k).bc =  BACK2D_POLY4(all_spots(k).sp,25,1.2,0)
  dum = WHERE((all_spots(k).sp - all_spots(k).bc) GE MAX(all_spots(k).sp - all_spots(k).bc)/2.0,count)
  all_spots(k).fwhm = 0.001*pix_size*SQRT(count)
 ENDFOR

;Remove spots which have a bad FWHM, spots which are shifted.
 sigma = STDEV(all_spots.fwhm,mean) 
 w_fwhm = WHERE((all_spots.fwhm - mean)^2 LE 5.0*sigma^2,count)
 IF (count GT 0) THEN BEGIN
  all_spots=all_spots(w_fwhm) 
  sel_ref=sel_ref(w_fwhm) 
  PRINT,'Number of spots rejected for bad FWHM: ',n_ref-count
  n_ref=count
 ENDIF

  bs=large_boxsize
  bsx2 = FIX(bs/2.)
  bsy2 = FIX(bs/2.)

  FOR k=0,(n_ref-1) DO all_spots(k).max_val=MAX(all_spots(k).sp(bsx2-bsx2/2:bsx2+bsx2/2,bsy2-bsy2/2:bsy2+bsy2/2))

  w_shift = WHERE( $
  all_spots.sp(FIX(bs*bsy2+bsx2)) EQ LONG(all_spots.max_val) OR $
  all_spots.sp(FIX(bs*bsy2+bsx2-1)) EQ LONG(all_spots.max_val) OR $
  all_spots.sp(FIX(bs*bsy2+bsx2+1)) EQ LONG(all_spots.max_val) OR $
  all_spots.sp(FIX(bs*(bsy2-1)+bsx2)) EQ LONG(all_spots.max_val) OR $
  all_spots.sp(FIX(bs*(bsy2-1)+bsx2-1)) EQ LONG(all_spots.max_val) OR $
  all_spots.sp(FIX(bs*(bsy2-1)+bsx2+1)) EQ LONG(all_spots.max_val) OR $
  all_spots.sp(FIX(bs*(bsy2+1)+bsx2)) EQ LONG(all_spots.max_val) OR $
  all_spots.sp(FIX(bs*(bsy2+1)+bsx2-1)) EQ LONG(all_spots.max_val) OR $
  all_spots.sp(FIX(bs*(bsy2+1)+bsx2+1)) EQ LONG(all_spots.max_val) $
  ,count)
 IF (count GT 0) THEN BEGIN
  all_spots=all_spots(w_shift) 
  sel_ref=sel_ref(w_shift) 
  PRINT,'Number of spots rejected for bad shift: ',n_ref-count
  n_ref=count
 ENDIF

;Compute the average spot and remove its background.
average_spot=all_spots(0).sp
FOR k=1,(n_ref-1) DO average_spot=average_spot+all_spots(k).sp

average_spot=LONG(average_spot/FLOAT(n_ref))
average_bc = BACK2D_POLY4(average_spot,25,1.2,0)

;Display this to the user.
 PRINT,'Examine the spot and click Done to continue'
 XSURFACE1,average_spot-average_bc
  
 obox=average_spot-average_bc


 ;display in study window
  WSET,study_win
  reb_fac_x=FIX(!D.X_SIZE/boxsize.x)
  reb_fac_y=FIX(!D.Y_SIZE/boxsize.y)

  box = CONGRID(obox,boxsize.x*reb_fac_x,boxsize.y*reb_fac_y)
  TVSCL,ALOG(box>1)

  ;draw a cross at that position
  cen_x = FIX(boxsize.x*reb_fac_x/2.)
  cen_y = FIX(boxsize.y*reb_fac_y/2.)
  DEVICE,SET_GRAPHICS=6
  col = 1
  WHILE col lt !d.table_size do col = col + col
  c1= [cen_x,cen_x]
  c2= [cen_y-reb_fac_y,cen_y+reb_fac_y]
  c3= [cen_x-reb_fac_x,cen_x+reb_fac_x]
  c4= [cen_y,cen_y]
  PLOTS,c1,c2,COL=col,/DEVICE
  PLOTS,c3,c4,COL=col,/DEVICE
  DEVICE,SET_GRAPHICS=3

  w=WHERE(obox EQ MAX(obox))
  chk = WHERESUB(w(0),obox)
  PRINT,'Maximum at : ',chk
  IF (chk(0) NE FIX(boxsize.x/2.)) OR (chk(1) NE FIX(boxsize.y/2.)) THEN $
   PRINT,'Spot not well centered, best it to try again ...'
  
;  WIDGET_CONTROL,state.info, SET_VALUE='Now define the border of the spot region ...' 
  bregion = DRAW_DEFROI(state.study,/RESTORE,ZOOM=[1,1])
  IF (SIZE(bregion))(0) NE 0 THEN BEGIN
   WSET,study_win
   tmp=INTARR(!D.X_SIZE,!D.Y_SIZE)
   big_xy = WHERESUB(bregion,tmp)
   reg_x = FIX(FLOAT(big_xy)/FLOAT(reb_fac_x))
   reg_y = FIX(IMAGINARY(big_xy)/FLOAT(reb_fac_y))
   comp_region = reg_x + boxsize.x*reg_y
   obox2=obox
   obox2(*)=0
   obox2(comp_region)=1
   region = WHERE(obox2 EQ 0)
   SURFACE,obox2
   field={file:STRCOMPRESS(state.masking.regionfile,/REMOVE_ALL)}
   field_title=['Enter region file : ']
   XSCRMENU,field,titles=field_title,/NOTYPE,/INTERP,FIELDLEN=60,ACTION=action
   IF action EQ 'DO' THEN BEGIN
	state.masking.regionfile=field.file
	boxsize_reg=boxsize
	SAVE,region,boxsize_reg,FILE=field.file
	GOTO,end_of_routine
   ENDIF
  ENDIF 
   WIDGET_CONTROL,state.info, SET_VALUE='Redo with left mouse on zoom window or leave with right mouse ...' 

  ;plot a square around the spot
  WSET,state.zoom_win
  DEVICE,SET_GRAPHICS=6
  PLOTS,TRANSPOSE([t1,t2,t3,t4,t1]),COL=col,/DEVICE
  DEVICE,SET_GRAPHICS=3

end_of_routine:
END




