function BACK2D_QUICK,array, percentage,dark_current,SHOW=SHOW,noise_index=noise_index
;+
; NAME:
;	BACK2D_QUICK
;
; PURPOSE:
;	Simple estimation of mean background
;
; CATEGORY:
;	Data processing.
;
; CALLING SEQUENCE:
;	back = BACK2D_QUICK(array,percentage,dark_current,/SHOW,noise_index=noise_index)
;
; INPUTS:
;	array : the array to process
;	percentage : the initial percentage of the pixels to consider as noise. (the closer
;		this value to the real percentage, the faster the routine converges)
;	dark_current : the dark current of the detector (a constant offset)
;	show : keyword set to print info
;
; OUTPUTS:
;	noise_index : [optional] the indices of the pixels selected for
;		background calculation
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;	None.
;
; PROCEDURE:
;	Straightforward
;
; MODIFICATION HISTORY:
;	Dominique Bourgeois, June 97.
;-

arr_size=SIZE(array)
xsize=arr_size(1)
ysize=arr_size(2)
totsize=arr_size(4)

;the number of pixels to be considered as background as a starting point is
number_back = FIX(percentage/100.*totsize)

;take the smaller pixels which are not below the dark current
;w = WHERE(array GT dark_current,count)
;w2 = (SORT(array(w)))(0:(count-1)<(number_back-1))
;noise_index = w(w2)

;take the smaller pixels which are not below the dark current
;one quarter in each quadrant
array1=array(0:FIX(xsize/2.)-1,0:FIX(ysize/2.)-1)
array2=array(0:FIX(xsize/2.)-1,FIX(ysize/2.)+1:ysize-1)
array3=array(FIX(xsize/2.)+1:xsize-1,0:FIX(ysize/2.)-1)
array4=array(FIX(xsize/2.)+1:xsize-1,FIX(ysize/2.)+1:ysize-1)

wd1 = WHERE(array1 GT dark_current,count1)
wd2 = WHERE(array2 GT dark_current,count2)
wd3 = WHERE(array3 GT dark_current,count3)
wd4 = WHERE(array4 GT dark_current,count4)

IF count1 EQ 0 OR count2 EQ 0 OR count3 EQ 0 OR count4 EQ 0 THEN BEGIN
 w = WHERE(array GT dark_current,count)
 w2 = (SORT(array(w)))(0:(count-1)<(number_back-1))
 noise_index = w(w2)
 GOTO,skip_quadrant 
ENDIF

w1 = (SORT(array1(wd1)))(0:(count1-1)<(number_back/4-1))
w2 = (SORT(array2(wd2)))(0:(count2-1)<(number_back/4-1))
w3 = (SORT(array3(wd3)))(0:(count3-1)<(number_back/4-1))
w4 = (SORT(array4(wd4)))(0:(count4-1)<(number_back/4-1))

;list of all correct noise indices in each quadrant
ni1=wd1(w1)
ni2=wd2(w2)
ni3=wd3(w3)
ni4=wd4(w4)

;we now need to convert this into the noise indices of the full array
xy1 = WHERESUB(ni1,array1)
xy2 = WHERESUB(ni2,array2)+ COMPLEX(0,FIX(ysize/2.)+1)
xy3 = WHERESUB(ni3,array3)+ COMPLEX(FIX(xsize/2.)+1,0)
xy4 = WHERESUB(ni4,array4)+ COMPLEX(FIX(xsize/2.)+1,FIX(ysize/2.)+1)

wf1=FIX(xy1)+xsize*FIX(IMAGINARY(xy1)) & sf1=(SIZE(wf1))(1)
wf2=FIX(xy2)+xsize*FIX(IMAGINARY(xy2)) & sf2=(SIZE(wf2))(1)
wf3=FIX(xy3)+xsize*FIX(IMAGINARY(xy3)) & sf3=(SIZE(wf3))(1)
wf4=FIX(xy4)+xsize*FIX(IMAGINARY(xy4)) & sf4=(SIZE(wf4))(1)

noise_index = INTARR(sf1+sf2+sf3+sf4)
noise_index(0:sf1-1)=wf1
noise_index(sf1:sf1+sf2-1)=wf2
noise_index(sf1+sf2:sf1+sf2+sf3-1)=wf3
noise_index(sf1+sf2+sf3:sf1+sf2+sf3+sf4-1)=wf4

skip_quadrant: 


;help,noise_index
;dum_array=array
;dum_array(*)=0
;dum_array(noise_index)=1
;print,'cycle_number : ',number_cycle
;ok=''
;surface,dum_array
;print,array(noise_index)
;read,'Ok ? ',ok

noise_density = array(noise_index)


bc_mean=TOTAL(noise_density)/(SIZE(noise_density))(1)

IF KEYWORD_SET(show) THEN BEGIN
PRINT,'Mean background value :',bc_mean
ENDIF

RETURN,bc_mean
END




