function DRAW_SET_RDBW,state,refl,par,weak_refl=weak_refl
;+
; NAME:
;	DRAW_SET_RDBW
;
; PURPOSE:
;	Set the RDBW method
;
; CATEGORY:
;	Data processing
;
; CALLING SEQUENCE:
;	refl_ok=DRAW_SET_RDBW(state,refl,par,[weak_refl=weak_refl])
;
; INPUTS:
;	state: the state as defined in the widget program PROW
;	refl:the initial list of all reflections
;	par:the general parameters
;
; OUTPUTS:
;	refl_ok = the part of refl that have passed the RDBW test and that will actually be integrated.
;	weak_refl = [optional] the part of refl that have not passed the RDBW test and that will not be integrated.
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;
; PROCEDURE:
;	Straightforward.
;
; MODIFICATION HISTORY:
;	D.Bourgeois, March 1999.
;-
 

rdbw_mode = state.exclude
norm_file = state.normalization_curve
mono_file = state.complete_data_file
b_factor = state.b_factor
threshold = state.exclude_threshold

PRINT,'Will now exclude weak reflexions : '

use_mono=0 ; by default do not use monochromatic data
mult=0 ; by default do not care about multiples

IF mono_file NE '' THEN BEGIN
 use_mono=1 ; set usage of monochromatic data
 ; First read in the monochromatic data
 PRINT,'Will use monochromatic data for RDBW ...'
 PRINT,'Reading in monochromatic data : ',mono_file
 RESTORE,mono_file
 IF N_ELEMENTS(laue_group) EQ 0 THEN MESSAGE,'Laue group number was not specified in : '+ mono_file
 PRINT,'Laue group number is : ',laue_group
 sig_mono=STDEV(mono.entry(0),mean_mono)
 PRINT,'Standard deviation and mean of normalized mono data : ', sig_mono,mean_mono
 PRINT,'Monochromatic SF will be normalized to a median value of 1'
 ;try to normalize the mono SF's
 mono.entry(0)=mono.entry(0)/MEDIAN(mono.entry(0))
 ;Then combine with monochromatic F's
 refl=GET_MONOF(refl,mono,mult=mult,laue_group=laue_group)
 ;the monochromatic structure factor amplitude. 
 ;mult contains the informations for the DOUBLES. We don't treat the
 ;problem for multiples higher than doubles.
ENDIF

;open the normalization curve (from GET_SPECTRUM_POL.PRO for a calculated lambda_curve)
;this file should contain a polynom called 'lambdapol'
RESTORE,norm_file
IF N_ELEMENTS(lambdapol) EQ 0 THEN MESSAGE,'Normalisation curve was not specified in : '+ norm_file

CASE rdbw_mode OF 
  1: 	BEGIN ; RDBW from LSCALE
		lscale=1 & use_rdbw=1
	END


  2: 	BEGIN ; RDBW from LAUENORM
		lscale=0 & use_rdbw=1
	END


  3: 	BEGIN ; RDBW from calculated curve
		use_rdbw=0 & lscale=0
	END


  ELSE: MESSAGE,'This option for RDBW does not exist. Check parameters !'

ENDCASE
refl=PRED_II(refl, lambdapol, b_factor, scale=1,threshold=threshold,weak=weak_refl,mult=mult,USE_RDBW=USE_RDBW,LSCALE=LSCALE,USE_MONO=USE_MONO,lmin=par.lmin,lmax=par.lmax) 

RETURN,refl

;***********************************
END
;***********************************
;-














