pro DRAW_PULL_COLOR,state,image_state,event
;+
; NAME:
;	DRAW_PULL_COLOR
;
; PURPOSE:
;	Manages color pull down menu.
;
; CATEGORY:
;	Data processing
;
; CALLING SEQUENCE:
;	DRAW_PULL_COLOR,state,image_state,event
;
; INPUTS:
;	state: the state as defined in the widget program LOOK_MAR18.
;	image_state: the state as defined in the widget program PROW_DRAW
;	event: the event related to the choice in the pull down menu
; OUTPUTS:
;	None
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;
; PROCEDURE:
;	Straightforward.
;
; MODIFICATION HISTORY:
;	D.Bourgeois, January 1998.
;-

COMMON SHARE_PROW,pred,sel_pred,par


CASE event.value OF 
 1 : BEGIN ; Change the parameters
	LOADCT,0
	blue_col=[255,0,0]
	green_col=[0,255,0]
	red_col=[0,0,255]
	TVLCT,red_col,green_col,blue_col,!D.N_COLORS-3
     END

 2 : BEGIN ; Load main color table
	blue_col=[255,0,0]
	green_col=[0,255,0]
	red_col=[0,0,255]
	XLOADCT,GROUP=event.top,NCOLORS=!D.N_COLORS-3
       END

 ELSE : WIDGET_CONTROL,state.info,SET_VALUE='Info : Error !'
ENDCASE



END










