pro DRAW_PRINT,state,image_state
;+
; NAME:
;	DRAW_PRINT
;
; PURPOSE:
;	Print a window.
;
; CATEGORY:
;	Data processing
;
; CALLING SEQUENCE:
;	DRAW_PRINT,state,image_state
;
; INPUTS:
;	state: the state as defined in the widget program LOOK_MAR18.
;	image_state: the state as defined in the widget program PROW_DRAW.
;
; OUTPUTS:
;	None
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;
; PROCEDURE:
;	Straightforward.
;
; MODIFICATION HISTORY:
;	D.Bourgeois, May 1997.
;-

COMMON SHARE_PROW,pred,sel_pred,par

;give a message
WIDGET_CONTROL,state.info,SET_VALUE='Info : Click with left mouse on the window you want to plot (right mouse to cancel) ...'

;wait for an event
WHILE 1 DO BEGIN
 ev = WIDGET_EVENT([image_state.draw,image_state.zoom,image_state.study])
 win_id=ev.id ; from which window
 IF ev.press EQ 4 THEN GOTO,cut_print ;leave the routine
 IF ev.press THEN BEGIN
  field={file:state.print.file}
  field_title=['Enter postcript filename']
  XSCRMENU,field,titles=field_title,/NOTYPE,/INTERP,ACTION=action,FIELDLEN=60
  IF action EQ 'DO' THEN BEGIN
   state.print.file=field.file
   CASE win_id OF
    image_state.draw  : $
	BEGIN
	 WSET,image_state.draw_win
	 WIDGET_CONTROL,state.info,SET_VALUE='Info : Printing main window on : ' + field.file
	 x=!D.X_SIZE & y=!D.Y_SIZE 
	 SET_PLOT,'ps',/INTERPOLATE ;set the device to ps
	 DEVICE,FILENAME=field.file,XOFFSET=0.5,YOFFSET=5,XSIZE=20,YSIZE=20,/PORTRAIT,/COLOR,BITS_PER_PIXEL=8
	 psx=!D.X_SIZE/FLOAT(x)/image_state.bin_fac
	 psy=!D.Y_SIZE/FLOAT(y)/image_state.bin_fac 
         IF image_state.log_status EQ 0 THEN $
	  TVSCL,*image_state.orig_image ELSE $
	  TVSCL,ALOG((*image_state.orig_image)>1)
	 IF image_state.pred.status THEN $ ;overplot predictions
	  dummy=DRAW_PRED(sel_pred,image_state.x_im_sz,image_state.y_im_sz,1,par,0,0,state,DRAW=image_state.boxinteg.boxsize,PSX=psx,PSY=psy)
	 DEVICE,/CLOSE
	 SET_PLOT,'x'
	 GOTO,cut_print
	END
    image_state.zoom  : $
	BEGIN
	 WSET,image_state.zoom_win
	 WIDGET_CONTROL,state.info,SET_VALUE='Info : Printing zoom window on : ' + field.file
	 x=!D.X_SIZE & y=!D.Y_SIZE 
	 SET_PLOT,'ps',/INTERPOLATE ;set the device to ps
	 DEVICE,FILENAME=field.file,XOFFSET=5,YOFFSET=17.5,XSIZE=10,YSIZE=10,/LANDSCAPE,/COLOR,BITS_PER_PIXEL=8
	 psx=!D.X_SIZE/FLOAT(x) & psy=!D.Y_SIZE/FLOAT(y) 
         IF image_state.log_status EQ 0 THEN $
	  TVSCL,*image_state.zoom_image ELSE $
	  TVSCL,ALOG(*image_state.zoom_image>1)
	 IF image_state.pred.status THEN $ ;overplot predictions
	  dummy=DRAW_PRED(sel_pred,image_state.x_zm_sz,image_state.y_zm_sz,1./image_state.scale,par,image_state.x0,image_state.y0,state,DRAW=image_state.boxinteg.boxsize,PSX=psx,PSY=psy) 
	 DEVICE,/CLOSE
	 SET_PLOT,'x'
	 GOTO,cut_print
	END
    image_state.study : $
	BEGIN
	 WIDGET_CONTROL,state.info,SET_VALUE='Info : Printing study window on : ' + field.file
	 WSET,image_state.study_win
	 tmp=TVRD()
	 SET_PLOT,'ps',/INTERPOLATE ;set the device to ps
	 DEVICE,FILENAME=field.file,XOFFSET=5,YOFFSET=17.5,XSIZE=14.5,YSIZE=10,/LANDSCAPE,/COLOR,BITS_PER_PIXEL=8
	 TV,tmp
	 DEVICE,/CLOSE
	 SET_PLOT,'x'
	 GOTO,cut_print
	END
   ENDCASE
  ENDIF ELSE GOTO,cut_print ; leave the routine
 ENDIF
ENDWHILE


cut_print:
WIDGET_CONTROL,state.info,SET_VALUE='Info : '

END








