FUNCTION DRAW_INFO,TITLE=title,XSIZE=xsize,YSIZE=ysize
;+
; NAME:
;	DRAW_INFO
;
; PURPOSE:
;	Creates a Text widget to receive infos. 
;
; CATEGORY:
;	Widget processing
;
; CALLING SEQUENCE:
;	info_id = DRAW_INFO(title=title)
;
; INPUTS:
;	title : [optional] contains the title of the info widget
;	xsize : [optional] the xsize of the info widget
;	ysize : [optional] the scrolling ysize of the info widget
;
; OUTPUTS:
;	The widget ID of the created widget.
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;
; PROCEDURE:
;	Straightforward
;
; MODIFICATION HISTORY:
;	D.Bourgeois, May 1997.
;-

IF N_ELEMENTS(title) EQ 0 THEN title='Info'


IF N_ELEMENTS(xsize) EQ 0 THEN xsize=100
IF N_ELEMENTS(ysize) EQ 0 THEN ysize=50

;create the text widget.
info_base = WIDGET_BASE(col=1,TITLE=title)
info_text = WIDGET_TEXT(info_base,WRAP=1,value='',SCR_YSIZE=ysize,SCR_XSIZE=xsize,/SCROLL)

WIDGET_CONTROL,info_base,/REALIZE        ;visualize the widget

RETURN,info_base
END










