
PRO DRAW_HELP_EVENT,event

WIDGET_CONTROL,event.id,GET_UVALUE=uval

IF uval THEN WIDGET_CONTROL,event.top,/DESTROY

END


pro DRAW_HELP,help_message,title=title
;+
; NAME:
;	DRAW_HELP
;
; PURPOSE:
;	Displays help infos on a widget 
;
; CATEGORY:
;	Widget processing
;
; CALLING SEQUENCE:
;	DRAW_HELP,help_message,title=title
;
; INPUTS:
;	help_message : a STRING containing message
;	title : [optional] contains the title of the help widget
; OUTPUTS:
;	None
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;
; PROCEDURE:
;	Straightforward
;
; MODIFICATION HISTORY:
;	D.Bourgeois, May 1997.
;-

IF N_ELEMENTS(title) EQ 0 THEN title='Help'

;create the text widget.
help_base = WIDGET_BASE(col=1,TITLE=title)

;nl=STRING("12b)
l=STRLEN(help_message)
xsize=40
;FOR i=0,l/xsize+1 DO STRPUT,help_message,nl,(i+1)*xsize
ysize=STRLEN(help_message)/xsize+5

help_text = WIDGET_TEXT(help_base,WRAP=1,value=help_message,YSIZE=ysize,XSIZE=xsize)
help_done = WIDGET_BUTTON(help_base,value='DONE',UVALUE=1)


WIDGET_CONTROL,help_base,/REALIZE        ;visualize the widget

XMANAGER,"DRAW_HELP",help_base, /MODAL

END










