function DRAW_GET_GENFILE,file
;+
; NAME:
;	DRAW_GET_GENFILE
;
; PURPOSE:
;	In file, tries to match the generic numbers.
;
; CATEGORY:
;	String processing
;
; CALLING SEQUENCE:
;	gfile=DRAW_GET_GENFILE(file)
;
; INPUTS:
;	file: a string
;
; OUTPUTS:
;	gfile : the same string as file where the number have been 
;	 	replaced by '###' if possible.
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;
; PROCEDURE:
;	Straightforward.
;
; MODIFICATION HISTORY:
;	D.Bourgeois, May 1997.
;-

f=STRCOMPRESS(STRMID(file,RSTRPOS(file,'/')+1,STRLEN(file)))
dir=STRMID(file,0,RSTRPOS(file,'/')+1)

;start by assuming 3 generic number ie '###'
ngen=3

again2:
n_steps=1
again1:
tmp_file=f
FOR i=0,n_steps-1 DO BEGIN

 p1=	RSTRPOS(tmp_file,'0')> $
	RSTRPOS(tmp_file,'1')> $
	RSTRPOS(tmp_file,'2')> $
	RSTRPOS(tmp_file,'3')> $
	RSTRPOS(tmp_file,'4')> $
	RSTRPOS(tmp_file,'5')> $
	RSTRPOS(tmp_file,'6')> $
	RSTRPOS(tmp_file,'7')> $
	RSTRPOS(tmp_file,'8')> $
	RSTRPOS(tmp_file,'9')

 IF p1 EQ -1 THEN BEGIN
  ngen=ngen-1
  IF ngen EQ 0 THEN RETURN,file
  GOTO,again2
 ENDIF
 tmp_file = STRMID(f,0,p1)
ENDFOR

IF ngen GE 2 THEN BEGIN
n2=STRMID(f,p1-1,1)
IF n2 EQ '0' OR $
   n2 EQ '1' OR $
   n2 EQ '2' OR $
   n2 EQ '3' OR $
   n2 EQ '4' OR $
   n2 EQ '5' OR $
   n2 EQ '6' OR $
   n2 EQ '7' OR $
   n2 EQ '8' OR $
   n2 EQ '9' THEN BEGIN ;OK two numbers found

 IF ngen EQ 3 THEN BEGIN ;look for a third
  n3=STRMID(f,p1-2,1)
  IF n3 EQ '0' OR $
    n3 EQ '1' OR $
    n3 EQ '2' OR $
    n3 EQ '3' OR $
    n3 EQ '4' OR $
    n3 EQ '5' OR $
    n3 EQ '6' OR $
    n3 EQ '7' OR $
    n3 EQ '8' OR $
    n3 EQ '9' THEN BEGIN ;OK 3 numbers found 

  froot=STRMID(f,0,p1-2)
  fend=STRMID(f,p1+1,STRLEN(f))
  gfile=STRCOMPRESS(dir+froot+'###'+fend,/REMOVE_ALL)
  RETURN,gfile
  ENDIF ELSE BEGIN ; only2 numbers found
   n_steps=n_steps+1
   GOTO,again1
  ENDELSE
 ENDIF ELSE BEGIN ; if not looking for a third
  froot=STRMID(f,0,p1-1)
  fend=STRMID(f,p1+1,STRLEN(f))
  gfile=STRCOMPRESS(dir+froot+'##'+fend,/REMOVE_ALL)
  RETURN,gfile
 ENDELSE
ENDIF ELSE BEGIN ; only 1 number found
  n_steps=n_steps+1
  GOTO,again1
ENDELSE
ENDIF ELSE BEGIN
  froot=STRMID(f,0,p1)
  fend=STRMID(f,p1+1,STRLEN(file))
  gfile=STRCOMPRESS(dir+froot+'#'+fend,/REMOVE_ALL)
  RETURN,gfile
ENDELSE

END










