pro DRAW_CONTOUR,image,click_id,show_id,print_id,scale,boxsize,fraction=fraction,bc_flag
;+
; NAME:
;	DRAW_CONTOUR
;
; PURPOSE:
;	Interactively shows contours of a spot
;
; CATEGORY:
;	Data processing
;
; CALLING SEQUENCE:
;	DRAW_CONTOUR,image,click_id,show_id,scale,boxsize,fraction=fraction
;
; INPUTS:
;	image : the original data image
;	click_id : the widget id of the click window where the image 
;		is displayed.
;	show_id : the widget id of the draw window where the contour
;		is displayed.
;	print_id : the widget id of the label window where calculated value
;		is displayed.
;	scale : the congrid factor for image
;	boxsize : size of the search box
;	fraction : [optional] contour level at which the contour is displayed
;			and the length calculated.  Default = 50.
;
; OUTPUTS:
;	None
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;
; PROCEDURE:
;	The user clicks with left mouse on one spot.
;	Click on the right mouse to leave.
;
; MODIFICATION HISTORY:
;	D.Bourgeois, May 1997.
;-

;get the window number of the showing widget

WIDGET_CONTROL, show_id, GET_VALUE=show_win
WIDGET_CONTROL, click_id, GET_VALUE=click_win
click_win=!D.WINDOW

button = 0

;size of "image"
imageX = (size(image))(1)
imageY = (size(image))(2)

boxsize.x=scale*boxsize.x
boxsize.y=scale*boxsize.y

;get the proper "fraction"
IF NOT KEYWORD_SET(fraction) THEN fraction = 50.

WHILE 1 DO BEGIN                ;Internal event loop   
	;wait for an event from the clicking window
    	ev = WIDGET_EVENT([click_id])
	button = ev.press  ;New button state   
	IF button EQ 4 THEN GOTO,cut_loop
 	 IF ev.press THEN BEGIN

	  x = ev.x    ;Pixel coordinates
	  y = ev.y
	  box = image(MAX([0,x-boxsize.x/2]):MIN([imageX-1,x+boxsize.x/2]),$
	      MAX([0,y-boxsize.y/2]):MIN([imageY-1,y+boxsize.y/2]))

	  ;subtract background
	  bc=BACK2D_POLY4(box,25,2,0,bc_flag)
 	  box=box-bc
	  WSET,show_win
	  CONTOUR,box,LEVELS=[MAX(box)*fraction/100.,MAX(box)]
	  IF bc_flag EQ 0 THEN  WIDGET_CONTROL,print_id, SET_VALUE=STRING(fraction,FORMAT='("Contour at [%] : ",f5.2)') ELSE $
				WIDGET_CONTROL,print_id, SET_VALUE=STRING(fraction,FORMAT='("Contour at [%] : ",f5.2," (Bad background !)")') 
	ENDIF
ENDWHILE 
cut_loop : 
END








