pro DRAW_CELL_PARAMETER, state,image_state
;+
; NAME:
;	DRAW_CELL_PARAMETER
;
; PURPOSE:
;	Get an estimate of cell parameter.
;
; CATEGORY:
;	Data processing
;
; CALLING SEQUENCE:
;	DRAW_CELL_PARAMETER,state,image_state
;
; INPUTS:
;	state: the state as defined in the widget program LOOK_MAR18.
;	image_state: the state as defined in the widget program PROW_DRAW
;
; OUTPUTS:
;	None
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;
; PROCEDURE:
;	Straightforward.
;
; MODIFICATION HISTORY:
;	D.Bourgeois, May 1997.
;-

WIDGET_CONTROL,state.info,SET_VALUE="In zoom window, click on two diffraction spots (left mouse) ... (right mouse to quit)"

;get the state from PROW_DRAW
;WIDGET_CONTROL, WIDGET_INFO(state.draw_image, /CHILD), GET_UVALUE=image_state, /NO_COPY

;go to the zoom window
WSET,image_state.zoom_win

n_press = 0
t1=LONARR(2,2) & t2=LONARR(2,2) & t3=LONARR(2,2) & t4=LONARR(2,2)
x12=LONARR(2) & y12=LONARR(2)
loc_x12=LONARR(2) & loc_y12=LONARR(2)

WHILE(1) DO BEGIN ;internal loop event
 ;get x,y,z and display
 ev = WIDGET_EVENT([image_state.zoom])
 x=image_state.x0+ FIX(ev.x/image_state.scale)
 y=image_state.y0+ FIX(ev.y/image_state.scale)
 z=(*image_state.orig_image)(x,y)
 WIDGET_CONTROL, image_state.xyz_show, SET_VALUE=STRING(x,y,z,FORMAT='("X:",i5," Y:",i5," Z:",i7)')
		  
 IF (ev.press EQ 1) AND (n_press LE 1) THEN BEGIN
  ;look for maximum around the click position
  boxsize=image_state.boxinteg.boxsize.x*image_state.scale
  loc_x=ev.x & loc_y=ev.y

  box = (*image_state.zoom_image)(MAX([0,loc_x-boxsize/2]):MIN([image_state.x_zm_sz-1,loc_x+boxsize/2]),MAX([0,loc_y-boxsize/2]):MIN([image_state.y_zm_sz-1,loc_y+boxsize/2]))
  ;find the maximum
  pos = WHERESUB(WHERE(box EQ MAX(box)),box)
  loc_x = FLOAT(pos(0))+ MAX([0,loc_x-boxsize/2])
  loc_y = IMAGINARY(pos(0))+ MAX([0,loc_y-boxsize/2])
  box = (*image_state.zoom_image)(MAX([0,loc_x-boxsize/2]):MIN([image_state.x_zm_sz-1,loc_x+boxsize/2]),MAX([0,loc_y-boxsize/2]):MIN([image_state.y_zm_sz-1,loc_y+boxsize/2]))

 x=image_state.x0+ FIX(loc_x/image_state.scale)
 y=image_state.y0+ FIX(loc_y/image_state.scale)
 z=(*image_state.orig_image)(x,y)
 WIDGET_CONTROL, image_state.xyz_show, SET_VALUE=STRING(x,y,z,FORMAT='("X:",i5," Y:",i5," Z:",i7)')

  x12(n_press)=x & y12(n_press)=y
  loc_x12(n_press)=loc_x & loc_y12(n_press)=loc_y

  ;plot a square around the spot
  DEVICE,SET_GRAPHICS=6
  col = 1
  WHILE col lt !d.table_size do col = col + col
  t1(n_press,*)= [MAX([0,loc_x-boxsize/2]),MAX([0,loc_y-boxsize/2])]
  t2(n_press,*)= [MAX([0,loc_x-boxsize/2]),MIN([image_state.y_zm_sz-1,loc_y+boxsize/2])]
  t3(n_press,*)= [MIN([image_state.x_zm_sz-1,loc_x+boxsize/2]),MIN([image_state.y_zm_sz-1,loc_y+boxsize/2])]
  t4(n_press,*)= [MIN([image_state.x_zm_sz-1,loc_x+boxsize/2]),MAX([0,loc_y-boxsize/2])]
  PLOTS,TRANSPOSE([t1(n_press,*),t2(n_press,*),t3(n_press,*),t4(n_press,*),t1(n_press,*)]),COL=col,/DEVICE

  n_press=n_press+1

  IF n_press EQ 2 THEN BEGIN ;get the estimate
   ;draw a line between the two spots
   PLOTS,[[loc_x12(0),loc_y12(0)],[loc_x12(1),loc_y12(1)]],COL=col,/DEVICE
   xcen=state.diff_par.cenx
   ycen=state.diff_par.ceny
   d=state.diff_par.distance
   raster=0.001*state.diff_par.raster ;raster in [mm]
   l=state.diff_par.lambda
   ;get the number of orders
   field={n_orders:1}
   field_title=['Enter number of orders : ']
   XSCRMENU,field,titles=field_title,/NOTYPE,/INTERP,ACTION=action
   IF action EQ 'DO' THEN BEGIN
    ;distance between two adjacent spots [mm]
    dt=raster*SQRT((x12(1)-x12(0))^2+(y12(1)-y12(0))^2)/(field.n_orders>1)
 print,'distance [mm] : ',dt
    ;middle of the line
    xm=0.5*TOTAL(x12) & ym=0.5*TOTAL(y12)
    ;distance of middle to center [mm]
    dp=raster*SQRT((xm-xcen)^2+(ym-ycen)^2)
 print,'distance to center [mm] : ',dp
    ;distance of middle to crystal [mm]
    d2=d/(COS(ATAN(dp/d)))
 print,'distance to crystal [mm] : ',d2
    ;cell estimate
    cell=l*d2/dt
    WIDGET_CONTROL,state.info,SET_VALUE=STRING(cell,FORMAT='("Cell estimate is [A] : ",f6.2)')
   ENDIF ELSE BEGIN
	WIDGET_CONTROL,state.info,SET_VALUE="Info :"
	GOTO,give_up_cell ;cancel press on xscrmenu
   ENDELSE
  GOTO,give_up_cell
  ENDIF
 ENDIF

 IF ev.press EQ 4 THEN BEGIN
  WIDGET_CONTROL,state.info,SET_VALUE="Info :"
  GOTO,give_up_cell
 ENDIF
ENDWHILE

give_up_cell:

IF n_press EQ 1 THEN BEGIN
 PLOTS,TRANSPOSE([t1(0,*),t2(0,*),t3(0,*),t4(0,*),t1(0,*)]),COL=col,/DEVICE
 WIDGET_CONTROL,state.info,SET_VALUE="Info :"
ENDIF

IF n_press EQ 2 THEN BEGIN
 PLOTS,TRANSPOSE([t1(0,*),t2(0,*),t3(0,*),t4(0,*),t1(0,*)]),COL=col,/DEVICE
 PLOTS,TRANSPOSE([t1(1,*),t2(1,*),t3(1,*),t4(1,*),t1(1,*)]),COL=col,/DEVICE
 PLOTS,[[loc_x12(0),loc_y12(0)],[loc_x12(1),loc_y12(1)]],COL=col,/DEVICE
ENDIF

;restore graphics
DEVICE,SET_GRAPHICS=3
;restore the state to PROW_DRAW
;WIDGET_CONTROL, WIDGET_INFO(state.draw_image, /CHILD), SET_UVALUE=image_state, /NO_COPY

END








