PRO WRITE_PDB,pdb, name, format=format,CNS=CNS,ONO=ONO, header=header, renumber=renumber,remove_zero_occ=remove_zero_occ
;+
; NAME:
;	WRITE_PDB
;
; PURPOSE:
;	Read in an PDB file.
;
; CATEGORY:
;	Input/Output
;
; CALLING SEQUENCE:
;   Result = WRITE_PDB(pdb, name,[format=format],[cns=cns], [ono=ono],[header=header],[/renumber],[/remove_zero_occ])
;
; INPUTS:
;	PDB: a structure with all atom information
;	NAME: String containing the name of the output PDB file.
;	format : [optionnal] for a special format just in case. 
;	default format is : '(7X,I4,A6,A3,2X,I4,4X,3F8.3,F6.2,F6.2)'
;	CNS : [optionnal] set this keyword for an CNS PDB format
;	ONO : [optionnal] set this keyword for an O PDB format
;	RENUMBER : set this keyword to renumber the pdb file.
;	REMOVE_ZERO_OCC : set this keyword to remove atoms with zero occupancies
;
; OUTPUTS:
;	WRITE_PDB writes out a structure with the atom info
;	.a	-->	ATOM or HETATM
;	.n	--> 	atom number
;	.t	--> 	atom type
;	.r	-->	residue name
;	.rn	-->	residue number
;	.c	-->	chain id
;	.x	-->	x position
;	.y	-->	y position
;	.z	-->	z position
;	.o	--> 	occupancy
;	.b	--> 	b-factor
;	.s	--> 	segment id
;
; SIDE EFFECTS:
;	A file is written.
;
; COMMENTS:
;	The number of atoms is limited by MAX_AT.
;
; MODIFICATION HISTORY:
;       Written by D. Bourgeois April 2002.
;-

;on_error,2                      ;Return to caller if an error occurs

max_at=50000
i=0L
cr = STRING("15b)

openw, file, name, /get_lun

IF N_PARAMS() LE 1 THEN format = '(7X,I4,A6,A3,2X,I4,4X,3F8.3,F6.2,F6.2)'
IF KEYWORD_SET(CNS) THEN format = '(A6,I5,2X,A3,A4,A2,I4,4X,3F8.3,F6.2,F6.2,6X,A4)'
IF KEYWORD_SET(ONO) THEN format = '(A6,I5,A4,2X,A3,1X,A1,I4,4X,3F8.3,F6.2,F6.2)'

a='' & n=0L & t='' & r='' & rn=0L & c=''& x=0.0 & y=0.0 & z=0.0 & o=0.0 & b=0.0 & s=''
dummy=''
i=0


IF N_ELEMENTS(header) EQ 0 OR (SIZE(header))(0) EQ 0 THEN BEGIN
 PRINT,'No header was available !'
 header= STRARR(1) & header(0)='REMARK PDB file written by IDL'
ENDIF ELSE PRINTF, file, 'REMARK PDB file modified by IDL'

IF KEYWORD_SET(renumber) THEN pdb.n = INDGEN((SIZE(pdb))(1))
IF KEYWORD_SET(remove_zero_occ) THEN BEGIN
 w_zero_occ = WHERE(pdb.o EQ 0,ct_zero_occ)
 IF ct_zero_occ GT 0 THEN BEGIN
  PRINT,'Number of atoms with zero occupancies: ',ct_zero_occ
  FOR i=0,ct_zero_occ-1 DO BEGIN
   PRINT,pdb(w_zero_occ(i)).rn, ' ',pdb(w_zero_occ(i)).r, ' ',pdb(w_zero_occ(i)).t
  ENDFOR
  pdb = pdb(WHERE(pdb.o GT 0))
 ENDIF
ENDIF



;print out header
FOR i=0, (SIZE(header))(1)-1 DO PRINTF, file, header(i)

FOR i=0, (SIZE(pdb))(1)-1 DO BEGIN
  IF i/100 EQ i/100.0 THEN PRINT,FORMAT="($,I5,' atoms written',A)",i,cr

  IF STRLEN(pdb(i).s) EQ 1 THEN pdb(i).s = pdb(i).s +'   '
  IF STRLEN(pdb(i).s) EQ 2 THEN pdb(i).s = pdb(i).s +'  '
  IF STRLEN(pdb(i).s) EQ 3 THEN pdb(i).s = pdb(i).s +' '

  IF STRLEN(pdb(i).t) EQ 1 THEN pdb(i).t = pdb(i).t +'   '
  IF STRLEN(pdb(i).t) EQ 2 THEN pdb(i).t = pdb(i).t +'  '
  IF STRLEN(pdb(i).t) EQ 3 THEN pdb(i).t = pdb(i).t +' '


  IF KEYWORD_SET(ONO) THEN $
   PRINTF, file, format=format, pdb(i).a,pdb(i).n,pdb(i).t,pdb(i).r,pdb(i).rn,pdb(i).x,pdb(i).y,pdb(i).z,pdb(i).o,pdb(i).b,pdb(i).s

  IF KEYWORD_SET(CNS) THEN $
   PRINTF, file, format=format, pdb(i).a,pdb(i).n,pdb(i).t,pdb(i).r,pdb(i).c,pdb(i).rn,pdb(i).x,pdb(i).y,pdb(i).z,pdb(i).o,pdb(i).b,pdb(i).s

  IF (NOT KEYWORD_SET(CNS)) AND (NOT KEYWORD_SET(ONO)) THEN $
   PRINTF, file, format=format, pdb(i).n,pdb(i).t,pdb(i).r,pdb(i).rn,pdb(i).x,pdb(i).y,pdb(i).z,pdb(i).o,pdb(i).b

ENDFOR

PRINTF, file, 'END'
free_lun, file
END 



