function RSYM, arr1,entry_no=entry_no,redun=redun,non_redun=non_redun
;+
; NAME:
;	RSYM
;
; PURPOSE:
;	Calculates a global R-factor (no binning)
;
; CATEGORY:
;	Crystallography, data analysis.
;
; CALLING SEQUENCE:
; 	rfactor = RSYM(arr1,[entry_no=entry_no],[redun=redun],[non_redun=non_redun])
;
; INPUTS:
;	ARR1 : The arrays containing the data to be scaled.
;
; KEYWORDED PARAMETERS:
;	entry_no : the structure array arr1 must contain a field .entry
;		the Rsym calculation is done on .entry(entry_no). See READ_MTZ.PRO.
;		Default = 2
;
; OUTPUTS:
;	rfactor : the calculated R-factor (on the whole data set). 
;	redun : [optional] the redunundant measurements
;	non_redun : [optional] the non redunundant measurements
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;	Before use, the data (arr1) must have been processed with GET_UNIQUE.PRO
;
; PROCEDURE:
;	Straightforward
;
; MODIFICATION HISTORY:
;	Dominique Bourgeois, 1998
;-

ON_ERROR, 2

IF N_ELEMENTS(entry_no) EQ 0 THEN entry_no=2

SORT_MILLER,arr1
num=0. & denum=0.
next_i=0L
n_unique=0L
n_redundant=0L
red=LONARR(11)
redun=arr1
non_redun=arr1
nredun=0
nnonredun=0

s_arr1=(SIZE(arr1))(1)
FOR loc_i = 0L,s_arr1-1 DO BEGIN
 REPEAT BEGIN
  next_i = (next_i+1)<s_arr1
 ENDREP UNTIL (arr1(next_i<(s_arr1-1)).m(0) NE arr1(next_i-1).m(0)) OR (arr1(next_i<(s_arr1-1)).m(1) NE arr1(next_i-1).m(1)) OR (arr1(next_i<(s_arr1-1)).m(2) NE arr1(next_i-1).m(2)) OR (next_i EQ s_arr1)
 IF (next_i-loc_i) GT 1 THEN BEGIN
	red((next_i-loc_i)<10)=red((next_i-loc_i)<10)+1
 	n_unique=n_unique+1
	n_redundant=n_redundant+next_i-loc_i
	imean = TOTAL(arr1(loc_i:next_i-1).entry(entry_no))/(next_i-loc_i)
 	num=num+TOTAL(ABS(imean-arr1(loc_i:next_i-1).entry(entry_no)))
 	denum=denum+TOTAL(arr1(loc_i:next_i-1).entry(entry_no))
        redun(nredun:nredun+next_i-loc_i-1)=arr1(loc_i:next_i-1)
	nredun=nredun+next_i-loc_i
 ENDIF ELSE BEGIN
  red(1)=red(1)+1
  non_redun(nnonredun)=arr1(loc_i)
  nnonredun=nnonredun+1
 ENDELSE
 loc_i=next_i-1
ENDFOR
r = num/denum
PRINT,'Rsym is [%] : ',100*r
PRINT,'Number of unique reflexions which are redundant : ',n_unique
PRINT,'Number of redundant measurements : ',n_redundant
PRINT,'Number of unique reflexions with redundancies 1,2,3,...9, >=10 : ',red(1:10)
redun=redun(0:nredun-1)
non_redun=non_redun(0:nnonredun-1)
RETURN, r
 
END
