FUNCTION READ_PDB,name,format=format,CNS=CNS,ONO=ONO, header=header
;+
; NAME:
;	READ_PDB
;
; PURPOSE:
;	Read in an PDB file.
;
; CATEGORY:
;	Input/Output
;
; CALLING SEQUENCE:
;   Result = READ_PDB(name,[format=format],[cns=cns], [ono=ono],[header=header],)
;
; INPUTS:
;	NAME: String containing the name of the PDB file.
;	format : [optionnal] for a special format just in case. 
;	default format is : '(7X,I4,A6,A3,2X,I4,4X,3F8.3,F6.2,F6.2)'
;	CNS : [optionnal] set this keyword for an CNS PDB format
;	ONO : [optionnal] set this keyword for an O PDB format
;
; OUTPUTS:
;	READ_PDB returns a structure with the atom info
;	.a	-->	ATOM or HETATM
;	.n	--> 	atom number
;	.t	--> 	atom type
;	.r	-->	residue name
;	.rn	-->	residue number
;	.x	-->	x position
;	.y	-->	y position
;	.z	-->	z position
;	.o	--> 	occupancy
;	.b	--> 	b-factor
;
; SIDE EFFECTS:
;	A file is read.
;
; COMMENTS:
;	The number of atoms is limited by MAX_AT.
;
; MODIFICATION HISTORY:
;       Written by D. Bourgeois March 96.
;-

;on_error,2                      ;Return to caller if an error occurs

max_at=50000
i=0L
cr = STRING("15b)

openr, file, name, /get_lun

IF N_PARAMS() LE 1 THEN format = '(A6,I5,A5,A4,2X,I4,4X,3F8.3,F6.2,F6.2)'
IF KEYWORD_SET(CNS) THEN format = '(A6,I5,A5,A4,A2,I4,4X,3F8.3,F6.2,F6.2,6X,A4)'
IF KEYWORD_SET(ONO) THEN format = '(A6,I5,A5,A4,1X,A1,I4,4X,3F8.3,F6.2,F6.2)'

IF KEYWORD_SET(CNS) OR KEYWORD_SET(ONO) THEN $
 atom = {a: '', n:0L, t:'', r:'', rn:0L, c:'', x:0.0, y:0.0, z:0.0, o:0.0, b:0.0, s:''} $
ELSE $
 atom = {a: '',n:0L, t:'', r:'', rn:0L, x:0.0, y:0.0, z:0.0, o:0.0, b:0.0 }


mol = replicate(atom, max_at) 

a='' & n=0L & t='' & r='' & rn=0L & c='' & x=0.0 & y=0.0 & z=0.0 & o=0.0 & b=0.0 & s=''
dummy=''
i=0

;read header
header = STRARR(1000)
j=0

READF, file, dummy
WHILE (STRMID(dummy,0,4) NE 'ATOM') DO BEGIN
 header(j) = dummy
 j=j+1
 READF, file, dummy
ENDWHILE
IF j NE 0 THEN header=header(0:j-1) ELSE header=0

WHILE (NOT EOF(file)) DO BEGIN
  IF i/100 EQ i/100.0 THEN PRINT,FORMAT="($,I5,' atoms read',A)",i,cr
IF (STRMID(dummy,0,3) NE 'END' AND STRMID(dummy,0,3) NE 'TER' AND STRMID(dummy,0,6) NE 'REMARK') THEN BEGIN
  IF KEYWORD_SET(ONO) THEN $
   READS,dummy,FORMAT=format,a,n,t,r,c,rn,x,y,z,o,b
  IF KEYWORD_SET(CNS) THEN $
   READS,dummy,FORMAT=format,a,n,t,r,c,rn,x,y,z,o,b,s
  IF (NOT KEYWORD_SET(CNS)) AND (NOT KEYWORD_SET(ONO)) THEN $
   READS,dummy,FORMAT=format,a,n,t,r,rn,x,y,z,o,b
  mol(i).a =  a
  mol(i).n =  n
  mol(i).t =  t
  mol(i).r =  r
  mol(i).c =  c
  mol(i).rn = rn
  mol(i).x = x
  mol(i).y = y
  mol(i).z = z
  mol(i).o = o
  mol(i).b = b
  IF KEYWORD_SET(CNS) OR KEYWORD_SET(ONO) THEN BEGIN
    mol(i).s = STRCOMPRESS(s,/REMOVE_ALL)
  ENDIF 
 i = i + 1
ENDIF
  READF, file, dummy
ENDWHILE

free_lun, file

mol = mol(0:i-1)

w = WHERE(STRMID(STRCOMPRESS(mol.t,/REMOVE_ALL),0,1) EQ 'C',ct1)
PRINT,'Number of Carbon atoms : ',ct1

w = WHERE(STRMID(STRCOMPRESS(mol.t,/REMOVE_ALL),0,1) EQ 'N',ct2)
PRINT,'Number of Nitrogen atoms : ',ct2

w = WHERE(STRMID(STRCOMPRESS(mol.t,/REMOVE_ALL),0,1) EQ 'O',ct3)
PRINT,'Number of Oxygen atoms (including waters) : ',ct3

w = WHERE(STRMID(STRCOMPRESS(mol.t,/REMOVE_ALL),0,1) EQ 'S',ct4)
PRINT,'Number of Sulfur atoms : ',ct4

w = WHERE(STRMID(STRCOMPRESS(mol.t,/REMOVE_ALL),0,1) EQ 'P',ct5)
PRINT,'Number of Phosphate atoms : ',ct5

w = WHERE(STRMID(STRCOMPRESS(mol.t,/REMOVE_ALL),0,1) EQ 'H',ct6)
PRINT,'Number of Hydrogen atoms (including waters) : ',ct6

PRINT,'Number of Other atoms : ', (SIZE(mol))(1)-ct1-ct2-ct3-ct4-ct5-ct6

w = WHERE(	STRMID(STRCOMPRESS(mol.t,/REMOVE_ALL),0,2) EQ 'OW' OR $
		STRMID(STRCOMPRESS(mol.t,/REMOVE_ALL),0,3) EQ 'OH2' OR $
		STRMID(STRCOMPRESS(mol.r,/REMOVE_ALL),0,3) EQ 'HOH',ctw)
PRINT,'Number of Water molecules : ',ctw

mol = mol(0:i-1)

PRINT,'Total number of atoms (including waters) : ',(SIZE(mol))(1)
PRINT,'Total number of atoms (waters excluded, water hydrogen excluded)  : ',(SIZE(mol))(1)-ctw

mol.t = STRCOMPRESS(mol.t,/REMOVE_ALL)
mol.r = STRCOMPRESS(mol.r,/REMOVE_ALL)

return, mol
END 




