FUNCTION READ_CNS,name
;+
; NAME:
;	READ_CNS
;
; PURPOSE:
;	Read in an text-file from a XPLOR FCALC calculation.
;
; CATEGORY:
;	Input
;
; CALLING SEQUENCE:
;   Result = READ_CNS(name)
;
; INPUTS:
;	NAME: String containing the name of the xplor-file.
;
; OUTPUTS:
;	READ_CNS returns a structure with the reflection info
;	from the CNS-file
;
; SIDE EFFECTS:
;	A file is read.
;
; COMMENTS:
;	The number of reflections are limited by MAX_REF.
;
; MODIFICATION HISTORY:
;       Written by TU, 1994, Modified D. Bourgeois June 95.
;-

;on_error,2                      ;Return to caller if an error occurs

max_ref=50000
i=1L
cr = STRING("15b)

OPENR, file, name, /GET_LUN 

line = ''
REPEAT READF,file,line UNTIL (STRPOS(line,'INDE') NE -1)

;define the structure of the XPLOR file
searchstr = 'INDE'
pos_inde = STRPOS(line,searchstr)
IF pos_inde EQ -1 THEN GOTO, error
xplor_struc = CREATE_STRUCT('m',INTARR(3))

searchstr = 'FOBS'
pos_fobs = STRPOS(line,searchstr)
IF pos_fobs NE -1 THEN xplor_struc = CREATE_STRUCT(xplor_struc,'fo',0.0)

searchstr = 'PHAS'
pos_phas = STRPOS(line,searchstr)
IF pos_phas NE -1 THEN xplor_struc = CREATE_STRUCT(xplor_struc,'phio',0.0)

searchstr = 'SIGMA'
pos_sigm = STRPOS(line,searchstr)
IF pos_sigm NE -1 THEN xplor_struc = CREATE_STRUCT(xplor_struc,'sigma',0.0)

searchstr = 'FCALC'
pos_fcal = STRPOS(line,searchstr)
IF pos_fcal NE -1 THEN xplor_struc = CREATE_STRUCT(xplor_struc,'fc',0.0,'phic',0.0)

searchstr = 'FPART'
pos_fpar = STRPOS(line,searchstr)
IF pos_fpar NE -1 THEN xplor_struc = CREATE_STRUCT(xplor_struc,'fpc',0.0,'phipc',0.0)

searchstr = 'FOM'
pos_fom = STRPOS(line,searchstr)
IF pos_fom NE -1 THEN xplor_struc = CREATE_STRUCT(xplor_struc,'fom',0.0)

searchstr = 'TEST'
pos_test = STRPOS(line,searchstr)
IF pos_test NE -1 THEN xplor_struc = CREATE_STRUCT(xplor_struc,'test',0.0)

ref = REPLICATE(xplor_struc,max_ref)

;define current parameters
h=0 & k=0 & l=0 & fc=0.0 & phic=0.0 & fom=0.0
fo= 0.0 & phio= 0.0 & sigma= 0.0 & fpc= 0.0 & phipc=0.0
test=0


;read in the first line
h = FIX(STRMID(line,pos_inde+5,5))
k = FIX(STRMID(line,pos_inde+10,5))
l = FIX(STRMID(line,pos_inde+15,5))


ref(0).m(0) = h & ref(0).m(1) = k & ref(0).m(2) = l

IF pos_fobs NE -1 THEN BEGIN & fo = FLOAT(STRMID(line,pos_fobs+5,10)) & ref(0).fo = fo & END
IF pos_phas NE -1 THEN BEGIN & phio = FLOAT(STRMID(line,pos_phas+5,10)) & ref(0).phio = phio & END
IF pos_sigm NE -1 THEN BEGIN & sigma = FLOAT(STRMID(line,pos_sigm+6,10)) & ref(0).sigma = sigma & END
IF pos_fcal NE -1 THEN BEGIN & fc = FLOAT(STRMID(line,pos_fcal+6,9)) & ref(0).fc = fc & END
IF pos_fcal NE -1 THEN BEGIN & phic = FLOAT(STRMID(line,pos_fcal+16,9)) & ref(0).phic = phic & END
IF pos_fpar NE -1 THEN BEGIN & fpc = FLOAT(STRMID(line,pos_fpar+5,9)) & ref(0).fpc = fpc & END
IF pos_fpar NE -1 THEN BEGIN & phipc = FLOAT(STRMID(line,pos_fpar+14,9)) & ref(0).phipc = phipc & END
IF pos_fom  NE -1 THEN BEGIN & fom = FLOAT(STRMID(line,pos_fom+4,6)) & ref(0).fom = fom & END
IF pos_test  NE -1 THEN BEGIN & test = FLOAT(STRMID(line,pos_test+5,10)) & ref(0).test = test & END

WHILE (NOT EOF(file)) DO BEGIN
 READF,file,line
IF i/100 EQ i/100.0 THEN PRINT,FORMAT="($,I5,' reflexions read',A)",i,cr

h = FIX(STRMID(line,pos_inde+5,5))
k = FIX(STRMID(line,pos_inde+10,5))
l = FIX(STRMID(line,pos_inde+15,5))
ref(i).m(0) = h & ref(i).m(1) = k & ref(i).m(2) = l

IF pos_fobs NE -1 THEN BEGIN & fo = FLOAT(STRMID(line,pos_fobs+5,10)) & ref(i).fo = fo & END
IF pos_phas NE -1 THEN BEGIN & phio = FLOAT(STRMID(line,pos_phas+5,10)) & ref(i).phio = phio & END
IF pos_sigm NE -1 THEN BEGIN & sigma = FLOAT(STRMID(line,pos_sigm+6,10)) & ref(i).sigma = sigma & END
IF pos_fcal NE -1 THEN BEGIN & fc = FLOAT(STRMID(line,pos_fcal+6,9)) & ref(i).fc = fc & END
IF pos_fcal NE -1 THEN BEGIN & phic = FLOAT(STRMID(line,pos_fcal+16,9)) & ref(i).phic = phic & END
IF pos_fpar NE -1 THEN BEGIN & fpc = FLOAT(STRMID(line,pos_fpar+5,9)) & ref(i).fpc = fpc & END
IF pos_fpar NE -1 THEN BEGIN & phipc = FLOAT(STRMID(line,pos_fpar+14,9)) & ref(i).phipc = phipc & END
IF pos_fom  NE -1 THEN BEGIN & fom = FLOAT(STRMID(line,pos_fom+4,6)) & ref(i).fom = fom & END
IF pos_test  NE -1 THEN BEGIN & test = FLOAT(STRMID(line,pos_test+5,10)) & ref(i).test = test & END
  i = i + 1
ENDWHILE


PRINT,'Done !                '
PRINT,'Number of read reflexions : ',i

FREE_LUN, file

return, ref(0:i-1)
error:
return,0
END 



