PRO HKL_VIEW,filename,columns = columns,ascii = ascii,ref=ref,no_slicer=no_slicer
;+
; NAME:
;	HKL_VIEW
;
; PURPOSE:
;	Displays reciprocal space. Allows a study of
;	missing regions in reciprocal space.
;
; CATEGORY:
;	Laue processing.
;
; CALLING SEQUENCE:
;	hkl_view,filename,columns=columns,/ascii
;
; INPUTS:
;	filename : an mtz file from ccp4 suite
;	columns : number of columns in that file in addition to the 3 columns h,k,l
;		default is 2.
;	ascii : set this keyword to read from an ascii file
;	ref : if the data set is not read from a file, but directly input.
;	no_slicer : use this keyword if not using the slicer.
;
; OUTPUTS:
;	None
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;	None.
;
; PROCEDURE:
;	Calls the IDL routine "slicer"
;
; MODIFICATION HISTORY:
;	Dominique Bourgeois, September 95
;-

;ON_ERROR,2                              ;Return to caller if an error occurs
COMMON VOLUME_DATA, vol

IF N_ELEMENTS(ref) EQ 0 THEN BEGIN 
 IF N_ELEMENTS(columns) EQ 0 THEN columns = 2
 IF KEYWORD_SET(ascii) THEN BEGIN
  ;READ,'Enter # of rows : ',rows
  ;READ,'Enter # of columns : ',col
  refl=READ_ASCII(filename)
  h = refl(0,*) & k = refl(1,*) & l = refl(2,*)
 ENDIF ELSE BEGIN
  ref = READ_MTZ(filename,columns=colomns)
  h = ref.m(0) & k = ref.m(1) & l = ref.m(2)
 ENDELSE
ENDIF ELSE BEGIN
 h = ref.m(0) & k = ref.m(1) & l = ref.m(2)
ENDELSE

max_hkl = MAX([h,k,l])
min_hkl = MIN([h,k,l])
max_h = MAX(h) & min_h = MIN(h)
max_k = MAX(k) & min_k = MIN(k)
max_l = MAX(l) & min_l = MIN(l)
PRINT,'Minimum h,k,l : ',min_h,min_k,min_l
PRINT,'Maximum h,k,l : ',max_h,max_k,max_l

;d = BYTARR(max_hkl-min_hkl,max_hkl-min_hkl,max_hkl-min_hkl)
d = BYTARR(max_h-min_h,max_k-min_k,max_l-min_l)
d(h-min_h,k-min_k,l-min_l) = 100 ; ref.entry(0)

sm_factor = 2
d_sm = SMOOTH(d,sm_factor) 

IF KEYWORD_SET(no_slicer) THEN BEGIN
 ;display a contour of the accessed reciprocal space
 s = SIZE(d)
 ax = 30
 az = 45
 answer = ''
 SHADE_VOLUME,d_sm,MAX(d_sm)/2.,v,p


 REPEAT BEGIN
  menu:
  PRINT,''
  PRINT,'*********************************
  PRINT,'***********HKL VIEW**************
  PRINT,'*********************************
  PRINT,'ax : Set Ax value and draw :',ax
  PRINT,'az : Set Az value and draw :',az
  PRINT,'dr : Draw 3D map'
  PRINT,'x : Change colors'
  PRINT,'sm : Smoothing Factor :',sm_factor
  PRINT,'q : Quit'
  READ,answer

  IF answer EQ 'ax' THEN BEGIN
   READ,'New ax value :',ax 
   SCALE3,XRANGE=[0,s(1)],YRANGE=[0,s(2)],ZRANGE=[0,s(3)],AX=ax,AZ=az
   TV,SMOOTH(POLYSHADE(v,p,/T3D),5)
   GOTO,menu
  ENDIF

  IF answer EQ 'az' THEN BEGIN
   READ,'New az value :',az
   SCALE3,XRANGE=[0,s(1)],YRANGE=[0,s(2)],ZRANGE=[0,s(3)],AX=ax,AZ=az
   TV,SMOOTH(POLYSHADE(v,p,/T3D),5)
   GOTO,menu
  ENDIF

  IF answer EQ 'sm' THEN BEGIN
   READ,'New smoothing factor:',sm_factor
   IF sm_factor LE 1 THEN d_sm = d ELSE d_sm = SMOOTH(d,sm_factor) 
   SHADE_VOLUME,d_sm,MAX(d_sm)/2.,v,p
   GOTO,menu
  ENDIF

  IF answer EQ 'dr' THEN BEGIN
   SCALE3,XRANGE=[0,s(1)],YRANGE=[0,s(2)],ZRANGE=[0,s(3)],AX=ax,AZ=az
   TV,SMOOTH(POLYSHADE(v,p,/T3D),5)
   GOTO,menu
  ENDIF

  IF answer EQ 'x' THEN BEGIN
   XLOADCT
   GOTO,menu
  ENDIF

 ENDREP UNTIL answer EQ 'q'
ENDIF ELSE BEGIN

 vol = d_sm
 PRINT,'hkl planes are given by SLICER positions + : ',min_h,min_k,min_l

 SLICER
ENDELSE

END





