FUNCTION READ_Q4, file=file,rows=rows,columns=columns,offset=offset,erase=erase,display=display,NO_ROTATE=no_rotate,SWAP=swap
;+
; NAME:
;	READ_Q4
;
; PURPOSE:
;	Used to read images of format Q4 (ADSC detector)

; CATEGORY:
;	Input/output.
;
; CALLING SEQUENCE:
;   Result = READ_Q4([file=file],[rows=rows],[colums=columns],
;	[offset=offset],[/erase],[display=n],[NO_ROTATE=no_rotate],[SWAP=swap])
;
; INPUTS:
;	File {optionnal]: A string containing the name of file to read.
;	If the file ends with ".Z" the program assumes
;	the file has been compressed with the unix "compress"
;	command and will uncompress the file before reading.
;	Rows [optional]:the number of rows in the image : default=1200
;	Columns [optional]: the number of columns : default = 1200
;	Offset [optional]: the offset at which the data start : default = 2400
;	Erase [optional]: set this keyword to erase previous windows.
; 	Display [optional] : set display = n to display the Log of the image
;				rebinned by a factor of n
;	No_rotate [optional]: set this keyword to avoid rotating image
;	Swap [optional]: set this keyword to swap bytes.
;
; OUTPUTS:
;	READ_Q4 returns a long array containing the image data.
;
;
; SIDE EFFECTS:
;	A file is read.
;
;
; MODIFICATION HISTORY:
;       Written by Dominique BOURGEOIS, October 1999
;-

on_error,2                      ;Return to caller if an error occurs

IF N_ELEMENTS(file) EQ 0 THEN BEGIN
 file=PICKFILE(/READ,PATH=GETENV('DATA'),FILTER=['*'])
ENDIF

; Check if the file is compressed and act accordingly
; The temporary file is deleted after it has been read
;
if (strmid(file,(strlen(file)-2)(0),2) eq '.Z') then begin
	print, 'Comressed File! - Uncompressing...'
	spawn,  'zcat ' + file + ' >! /tmp/spefile.tmp'
	file = '/tmp/spefile.tmp'
endif

if n_elements(lun) le 0 then lun = -1	;Clean up
if lun gt 0 then free_lun, lun
openr,lun,file, error = i, /GET_LUN, /BLOCK
if i lt 0 then begin 			; Something wrong, 
	if lun gt 0 then free_lun,lun
	lun = -1
	print, 'Unable to open file: ' + file
	goto, nothing
endif
$ rm -f /tmp/gelfile.tmp
;
; Get image sizes
;

;first read the file header (512 bytes) as a byte array
header = BYTARR(512,/NOZERO)
READU,lun,header
header=STRING(header)
tmp_h=header
swap=0
IF KEYWORD_SET(swap) THEN swap=1

s='HEADER_BYTES='
IF STRPOS(tmp_h,s) GE 0 THEN BEGIN
p=STRPOS(tmp_h,s) & c=STRPOS(STRMID(tmp_h,p,1024),';') & wavelength=STRMID(tmp_h,p+STRLEN(s),c-STRLEN(s))

 c=STRPOS(tmp_h,';') & p=STRPOS(tmp_h,s) & header_bytes=STRMID(tmp_h,p+STRLEN(s),c-p-STRLEN(s))  & tmp_h=STRMID(tmp_h,c+2,STRLEN(tmp_h)-c)
ENDIF

s='DIM=' 
IF STRPOS(tmp_h,s) GE 0 THEN BEGIN
p=STRPOS(tmp_h,s) & c=STRPOS(STRMID(tmp_h,p,1024),';') & dim=STRMID(tmp_h,p+STRLEN(s),c-STRLEN(s))
ENDIF

s='BYTE_ORDER='
IF STRPOS(tmp_h,s) GE 0 THEN BEGIN
p=STRPOS(tmp_h,s) & c=STRPOS(STRMID(tmp_h,p,1024),';') & byte_order=STRMID(tmp_h,p+STRLEN(s),c-STRLEN(s))
IF byte_order EQ 'little_endian' THEN swap=1 
IF swap EQ 1 THEN PRINT,'Bytes will be swaped !'
ENDIF

s='TYPE=' 
IF STRPOS(tmp_h,s) GE 0 THEN BEGIN
p=STRPOS(tmp_h,s) & c=STRPOS(STRMID(tmp_h,p,1024),';') & type=STRMID(tmp_h,p+STRLEN(s),c-STRLEN(s))
ENDIF


s='SIZE1=' 
IF STRPOS(tmp_h,s) GE 0 THEN BEGIN
p=STRPOS(tmp_h,s) & c=STRPOS(STRMID(tmp_h,p,1024),';') & size11=STRMID(tmp_h,p+STRLEN(s),c-STRLEN(s))
ENDIF

s='SIZE2='
IF STRPOS(tmp_h,s) GE 0 THEN BEGIN
p=STRPOS(tmp_h,s) & c=STRPOS(STRMID(tmp_h,p,1024),';') & size12=STRMID(tmp_h,p+STRLEN(s),c-STRLEN(s))
ENDIF

s='PIXEL_SIZE=' 
IF STRPOS(tmp_h,s) GE 0 THEN BEGIN
p=STRPOS(tmp_h,s) & c=STRPOS(STRMID(tmp_h,p,1024),';') & pixel_size=STRMID(tmp_h,p+STRLEN(s),c-STRLEN(s))
PRINT,'Pixel size [mm] : ',pixel_size
ENDIF

s='BIN=' 
IF STRPOS(tmp_h,s) GE 0 THEN BEGIN
p=STRPOS(tmp_h,s) & c=STRPOS(STRMID(tmp_h,p,1024),';') & bin=STRMID(tmp_h,p+STRLEN(s),c-STRLEN(s))
ENDIF

s='ADC=' 
IF STRPOS(tmp_h,s) GE 0 THEN BEGIN
p=STRPOS(tmp_h,s) & c=STRPOS(STRMID(tmp_h,p,1024),';') & adc=STRMID(tmp_h,p+STRLEN(s),c-STRLEN(s))
ENDIF

s='DETECTOR_SN='
IF STRPOS(tmp_h,s) GE 0 THEN BEGIN
p=STRPOS(tmp_h,s) & c=STRPOS(STRMID(tmp_h,p,1024),';') & detector_sn=STRMID(tmp_h,p+STRLEN(s),c-STRLEN(s))
ENDIF

s='DATE=' 
IF STRPOS(tmp_h,s) GE 0 THEN BEGIN
p=STRPOS(tmp_h,s) & c=STRPOS(STRMID(tmp_h,p,1024),';') & date=STRMID(tmp_h,p+STRLEN(s),c-STRLEN(s))
PRINT,'Date : ',date
ENDIF

s='TIME=' 
IF STRPOS(tmp_h,s) GE 0 THEN BEGIN
p=STRPOS(tmp_h,s) & c=STRPOS(STRMID(tmp_h,p,1024),';') & time=STRMID(tmp_h,p+STRLEN(s),c-STRLEN(s))
ENDIF

s='DISTANCE=' 
IF STRPOS(tmp_h,s) GE 0 THEN BEGIN
p=STRPOS(tmp_h,s) & c=STRPOS(STRMID(tmp_h,p,1024),';') & distance=STRMID(tmp_h,p+STRLEN(s),c-STRLEN(s))
PRINT,'Detector distance [mm] : ',distance
ENDIF

s='OSC_RANGE=' 
IF STRPOS(tmp_h,s) GE 0 THEN BEGIN
p=STRPOS(tmp_h,s) & c=STRPOS(STRMID(tmp_h,p,1024),';') & osc_range=STRMID(tmp_h,p+STRLEN(s),c-STRLEN(s))
PRINT,'Osc range [deg] : ',osc_range
ENDIF

s='PHI=' 
IF STRPOS(tmp_h,s) GE 0 THEN BEGIN
p=STRPOS(tmp_h,s) & c=STRPOS(STRMID(tmp_h,p,1024),';') & phi=STRMID(tmp_h,p+STRLEN(s),c-STRLEN(s))
PRINT,'Phi [deg] : ',phi
ENDIF

s='OSC_START=' 
IF STRPOS(tmp_h,s) GE 0 THEN BEGIN
p=STRPOS(tmp_h,s) & c=STRPOS(STRMID(tmp_h,p,1024),';') & osc_start=STRMID(tmp_h,p+STRLEN(s),c-STRLEN(s))
PRINT,'Osc start [deg] : ',osc_start
ENDIF

s='AXIS=' 
IF STRPOS(tmp_h,s) GE 0 THEN BEGIN
p=STRPOS(tmp_h,s) & c=STRPOS(STRMID(tmp_h,p,1024),';') & axis=STRMID(tmp_h,p+STRLEN(s),c-STRLEN(s))
ENDIF

s='WAVELENGTH='
 IF STRPOS(tmp_h,s) GE 0 THEN BEGIN
p=STRPOS(tmp_h,s) & c=STRPOS(STRMID(tmp_h,p,1024),';') & wavelength=STRMID(tmp_h,p+STRLEN(s),c-STRLEN(s))
PRINT,'Wavelength [A] : ',wavelength
ENDIF

s='BEAM_CENTER_X='
IF STRPOS(tmp_h,s) GE 0 THEN BEGIN
p=STRPOS(tmp_h,s) & c=STRPOS(STRMID(tmp_h,p,1024),';') & beam_center_x=STRMID(tmp_h,p+STRLEN(s),c-STRLEN(s))
PRINT,'Beam center X [mm] : ',beam_center_x
ENDIF

s='BEAM_CENTER_Y='
 IF STRPOS(tmp_h,s) GE 0 THEN BEGIN
p=STRPOS(tmp_h,s) & c=STRPOS(STRMID(tmp_h,p,1024),';') & beam_center_y=STRMID(tmp_h,p+STRLEN(s),c-STRLEN(s))
PRINT,'Beam center Y [mm] : ',beam_center_y
ENDIF

s='SIZE1=' 
IF STRPOS(tmp_h,s) GE 0 THEN BEGIN
p=RSTRPOS(tmp_h,s) & c=STRPOS(STRMID(tmp_h,p,1024),';') & size21=STRMID(tmp_h,p+STRLEN(s),c-STRLEN(s))
ENDIF

s='SIZE2='
IF STRPOS(tmp_h,s) GE 0 THEN BEGIN
p=RSTRPOS(tmp_h,s) & c=STRPOS(STRMID(tmp_h,p,1024),';') & size22=STRMID(tmp_h,p+STRLEN(s),c-STRLEN(s))
ENDIF

s='CCD_IMAGE_SATURATION=' 
IF STRPOS(tmp_h,s) GE 0 THEN BEGIN
p=STRPOS(tmp_h,s) & c=STRPOS(STRMID(tmp_h,p,1024),';') & ccd_image_saturation=STRMID(tmp_h,p+STRLEN(s),c-STRLEN(s))
PRINT,'Saturation value [ADC counts] : ',ccd_image_saturation
ENDIF


;get the number of rows and columns
IF N_ELEMENTS(size21) EQ 0 THEN size21 = FIX(size11)
IF N_ELEMENTS(size22) EQ 0 THEN size22 = FIX(size12)

IF N_ELEMENTS(rows) EQ 0 THEN rows = FIX(size21)
IF N_ELEMENTS(columns) EQ 0 THEN columns = FIX(size22)
PRINT,'Number of rows [raster] : ',rows
PRINT,'Number of columns [raster] : ',columns

IF (N_ELEMENTS(offset) EQ 0) THEN offset=FIX(header_bytes)

free_lun, lun

print, 'Converting to Long Integer.'

image = lonarr(rows, columns, /nozero)

image_size = long(rows)*long(columns)

IF swap THEN $
 dummy = CALL_EXTERNAL(STRTRIM(GETENV('PROW_C')+'iq_lib.so'), 'ii_swap', image, image_size, file, long(offset)) $
ELSE $
 dummy = CALL_EXTERNAL(STRTRIM(GETENV('PROW_C')+'iq_lib.so'), 'no_swap', image, image_size, file, long(offset))

IF NOT KEYWORD_SET(no_rotate) THEN BEGIN
 PRINT,'Rotating image ...'
 image=ROTATE(TEMPORARY(image),4)
ENDIF

;shall we erase previous windows ?
IF KEYWORD_SET(erase) THEN REPEAT WDELETE UNTIL !D.WINDOW EQ -1

;following trick gives the right window number on the title
IF KEYWORD_SET(display) THEN BEGIN
window,!d.window+1,title=file+'  window:'+STRING(!D.WINDOW+1),xsize=rows/display,ysize=columns/display
print,!d.window
IF display NE 1 THEN TVSCL,ALOG(REBIN(image,rows/display,columns/display)>1) ELSE TVSCL,alog(image>1)
ENDIF

print, 'Done'
return, image

nothing:
return,0

end






















