FUNCTION READ_MARCCD, file=file,rows=rows,columns=columns,offset=offset,erase=erase,display=display,NO_ROTATE=no_rotate,SWAP=swap
;+
; NAME:
;	READ_MARCCD
;
; PURPOSE:
;	Used to read images of format MARCCD.

; CATEGORY:
;	Input/output.
;
; CALLING SEQUENCE:
;   Result = READ_MARCCD([file=file],[rows=rows],[colums=columns],
;	[offset=offset],[/erase],[display=n],[NO_ROTATE=no_rotate],[SWAP=swap])
;
; INPUTS:
;	File {optionnal]: A string containing the name of file to read.
;	If the file ends with ".Z" the program assumes
;	the file has been compressed with the unix "compress"
;	command and will uncompress the file before reading.
;	Rows [optional]:the number of rows in the image : default=1200
;	Columns [optional]: the number of columns : default = 1200
;	Offset [optional]: the offset at which the data start : default = 2400
;	Erase [optional]: set this keyword to erase previous windows.
; 	Display [optional] : set display = n to display the Log of the image
;				rebinned by a factor of n
;	No_rotate [optional]: set this keyword to avoid rotating image
;	Swap [optional]: set this keyword to swap bytes.
;
; OUTPUTS:
;	READ_MARCCD returns a long array containing the image data.
;
;
; SIDE EFFECTS:
;	A file is read.
;
;
; MODIFICATION HISTORY:
;       Written by Dominique BOURGEOIS, July 1996
;-

on_error,2                      ;Return to caller if an error occurs

IF N_ELEMENTS(file) EQ 0 THEN BEGIN
 file=PICKFILE(/READ,PATH=GETENV('DATA'),FILTER=['*'])
ENDIF

; Check if the file is compressed and act accordingly
; The temporary file is deleted after it has been read
;
if (strmid(file,(strlen(file)-2)(0),2) eq '.Z') then begin
	print, 'Comressed File! - Uncompressing...'
	spawn,  'zcat ' + file + ' >! /tmp/spefile.tmp'
	file = '/tmp/spefile.tmp'
endif

if n_elements(lun) le 0 then lun = -1	;Clean up
if lun gt 0 then free_lun, lun
openr,lun,file, error = i, /GET_LUN, /BLOCK
if i lt 0 then begin 			; Something wrong, 
	if lun gt 0 then free_lun,lun
	lun = -1
	print, 'Unable to open file: ' + file
	goto, nothing
endif
$ rm -f /tmp/gelfile.tmp
;
; Get image sizes
;

IF N_ELEMENTS(swap) EQ 0 THEN swap=0
IF N_ELEMENTS(rows) EQ 0 THEN rows = 2048
IF N_ELEMENTS(columns) EQ 0 THEN columns = 2048
IF (N_ELEMENTS(offset) EQ 0) THEN offset=4096

;first read the file header (2050 short int) as an int array
header = BYTARR(8,/NOZERO)
READU,lun,header

readu, lun, hdr
typ = STRING(header[0:1])		;Either MM or II
IF (typ ne 'MM') and (typ ne 'II') then begin
	ok=DIALOG_message('File is not a marccd file! ' + string(file),/error)
	return,lonarr(rows, columns, /nozero)
ENDIF

;see if bytes are swaped or not
IF swap EQ 0 THEN BEGIN
 ;order = typ eq 'MM'  		;1 if Motorola 0 if Intel (LSB first or vax)
 ;endian = byte(1,0,2)		;What endian is this?
 ;endian = endian[0] eq 0		;1 for big endian, 0 for little
 ;swap = order xor endian	;1 to swap...

 ;modified 24-10-00. The preceding code (for normal TIFF files) failed for LINUX
 swap = typ ne 'MM' 
ENDIF
IF swap THEN PRINT,'Bytes will be swaped ...'

FREE_LUN, lun

print, 'Reading image ...'

image = lonarr(rows, columns, /nozero)

image_size = long(rows)*long(columns)

IF swap THEN $
 dummy = CALL_EXTERNAL(STRTRIM(GETENV('PROW_C')+'iq_lib.so'), 'ii_swap', image, image_size, file, long(offset)) $
ELSE $
 dummy = CALL_EXTERNAL(STRTRIM(GETENV('PROW_C')+'iq_lib.so'), 'no_swap', image, image_size, file, long(offset))

IF NOT KEYWORD_SET(no_rotate) THEN BEGIN
 PRINT,'Rotating image ...'
 image=ROTATE(TEMPORARY(image),4)
ENDIF

;shall we erase previous windows ?
IF KEYWORD_SET(erase) THEN REPEAT WDELETE UNTIL !D.WINDOW EQ -1

;following trick gives the right window number on the title
IF KEYWORD_SET(display) THEN BEGIN
window,!d.window+1,title=file+'  window:'+STRING(!D.WINDOW+1),xsize=rows/display,ysize=columns/display
print,!d.window
IF display NE 1 THEN TVSCL,ALOG(REBIN(image,rows/display,columns/display)>1) ELSE TVSCL,alog(image>1)
ENDIF

print, 'Done'
return, image

nothing:
return,0

end






















