FUNCTION READ_MAR345, file=file,erase=erase,display=display,NO_ROTATE=no_rotate,PRINT_HEADER=print_header,SIZE_OF_IMAGE=size_of_image,ONLY_READ_SIZE=only_read_size
;+
; NAME:
;	READ_MAR345
;
; PURPOSE:
;	Used to read images of format MAR345

; CATEGORY:
;	Input/output.
;
; CALLING SEQUENCE:
;   Result = READ_MAR345([file=file],[/erase],[display=n],[NO_ROTATE=no_rotate),$
;			/PRINT_HEADER)
;
; INPUTS:
;	File [optionnal]: A string containing the name of file to read.
;	If the file ends with ".Z" the program assumes
;	the file has been compressed with the unix "compress"
;	command and will uncompress the file before reading.
;	Erase [optional]: set this keyword to erase previous windows.
; 	Display [optional] : set display = n to display the Log of the image
;				rebinned by a factor of n
;	No_rotate [optional]: set this keyword to avoid rotating image
;	Print_header    [optional]: set this keyword if the header is to be printed
;
; OUTPUTS:
;	READ_MAR345 returns a long array containing the image data.
;
;
; SIDE EFFECTS:
;	A file is read.
;
;
; MODIFICATION HISTORY:
;       Written by Dominique BOURGEOIS, October 1999
;-

on_error,2                      ;Return to caller if an error occurs

IF N_ELEMENTS(file) EQ 0 THEN BEGIN
 file=PICKFILE(/READ,PATH=GETENV('DATA'),FILTER=['*'])
ENDIF

; Check if the file is compressed and act accordingly
; The temporary file is deleted after it has been read
;
if (strmid(file,(strlen(file)-2)(0),2) eq '.Z') then begin
	print, 'Comressed File! - Uncompressing...'
	spawn,  'zcat ' + file + ' >! /tmp/spefile.tmp'
	file = '/tmp/spefile.tmp'
endif

if n_elements(lun) le 0 then lun = -1	;Clean up
if lun gt 0 then free_lun, lun
openr,lun,file, error = i, /GET_LUN, /BLOCK
if i lt 0 then begin 			; Something wrong, 
	if lun gt 0 then free_lun,lun
	lun = -1
	MESSAGE, 'Unable to open file: ' + file
	goto, nothing
endif
$ rm -f /tmp/gelfile.tmp

swap=0
;
; Get image sizes
;
;first read the file header (4096 bytes) as a byte array
header_size=4096
first_header_line=64

header = LONARR(first_header_line,/NOZERO)
READU,lun,header

POINT_LUN,lun,first_header_line
IF KEYWORD_SET(print_header) THEN BEGIN
 header_ascii = BYTARR(64,63,/NOZERO)
 READU,lun,header_ascii
 FOR i=0,62 DO BEGIN
  PRINT,STRING(header_ascii(*,i))
 ENDFOR
ENDIF

;check byteorder 
tmp_header=header(0:4)
tmp_header_sw=header(0:4)
BYTEORDER,tmp_header_sw,/LSWAP
IF ABS(STDEV(tmp_header_sw)) LT ABS(STDEV(tmp_header)) THEN BEGIN 
 PRINT,'Swapping bytes for header and large pixels values ...'
 BYTEORDER,header,/LSWAP
 swap=1
ENDIF

;get the number of rows and columns
IF N_ELEMENTS(rows) EQ 0 THEN rows = header(1)
IF N_ELEMENTS(columns) EQ 0 THEN columns = header(1)

size_of_image=[rows,columns]
IF KEYWORD_SET(only_read_size) THEN GOTO,nothing

;seek for saturated pixels (>=65535)
n_sat= header(2)
PRINT, 'Number of saturated pixels : ',header(2)

IF n_sat GE 1 THEN BEGIN
POINT_LUN,lun,header_size
sat_info = LONARR(n_sat*2,/NOZERO)
READU,lun,sat_info
IF swap EQ 1 THEN BYTEORDER,sat_info,/LSWAP

pos_info = LONARR(n_sat)
int_info = LONARR(n_sat)

FOR i=0,n_sat-1 DO BEGIN
	pos_info(i)=sat_info(2*i)
	int_info(i)=sat_info(2*i+1)
ENDFOR
ENDIF

FREE_LUN, lun
image = INTARR(rows, columns, /nozero)

dummy = CALL_EXTERNAL(STRTRIM(GETENV('PROW_C')+'pck.so'), 'get_pck', image, file)
image = LONG(image + (image LT 0)*65535L)

IF n_sat GE 1 THEN BEGIN
 PRINT,'Updating large pixel values ...'
 image(pos_info)=int_info
ENDIF

IF NOT KEYWORD_SET(no_rotate) THEN BEGIN
 PRINT,'Rotating image ...'
 image=ROTATE(TEMPORARY(image),4) 
ENDIF

;shall we erase previous windows ?
IF KEYWORD_SET(erase) THEN REPEAT WDELETE UNTIL !D.WINDOW EQ -1

;following trick gives the right window number on the title
IF KEYWORD_SET(display) THEN BEGIN
 window,!d.window+1,title=file+'  window:'+STRING(!D.WINDOW+1),xsize=rows/display,ysize=columns/display
 IF display NE 1 THEN TVSCL,ALOG(REBIN(image,rows/display,columns/display)>1) ELSE TVSCL,alog(image>1)
ENDIF

PRINT, 'Done'
RETURN, image

nothing:
RETURN,0

END






















