FUNCTION READ_BIN2, file=file,rows=rows,columns=columns,offset=offset,erase=erase,display=display,no_rotate=no_rotate,beamline=beamline,dump=dump,swap=swap,n_bytes=n_bytes
;+
; NAME:
;	READ_BIN2
;
; PURPOSE:
;	Read integers binary files into array of long signed integers

; CATEGORY:
;	Input/output.
;
; CALLING SEQUENCE:
;   Result = READ_BIN2([file=file],[rows=rows],[colums=columns],
;	[offset=offset],[/erase],[display=n],[no_rotate=no_rotate],
;	[beamline=beamline],[/dump],[/swap],[n_bytes=n_bytes])
;
; INPUTS:
;	File {optionnal]: A string containing the name of file to read.
;	If the file ends with ".Z" the program assumes
;	the file has been compressed with the unix "compress"
;	command and will uncompress the file before reading.
;	Rows [optional]:the number of rows in the image : default=1242
;	Columns [optional]: the number of columns : default = 1152
;	Offset [optional]: the offset at which the data start : default = 0
;	Erase [optional]: set this keyword to erase previous windows.
; 	Display [optional] : set display = n to display the Log of the image
;				rebinned by a factor of n
;	No_Rotate [optional] : set this keyword if the image is not to be rotated
;	Beamline [optional] : set this keyword if the image is to be rotated as at the ID9 beamline with DIS
;	Dump [optional] : set this keyword to just read the image with READU
;	Swap [optional] : set this keyword if bytes are to be swapped. Default=1
;	N_bytes [optional] : specify the number of bytes read per pixel. Default=2
;
; OUTPUTS:
;	READ_BIN2 returns a long array containing the image data.
;
;
; SIDE EFFECTS:
;	A file is read.
;
;
; MODIFICATION HISTORY:
;       Written by Dominique BOURGEOIS, September 1995
;-

on_error,2                      ;Return to caller if an error occurs

IF N_ELEMENTS(file) EQ 0 THEN BEGIN
 path = GETENV('DATA')
 file=PICKFILE(/READ,PATH=path,FILTER=['*'])
ENDIF

; Check if the file is compressed and act accordingly
; The temporary file is deleted after it has been read
;
IF (STRMID(file,(STRLEN(file)-2)(0),2) EQ '.Z') THEN BEGIN
 PRINT, 'Comressed File! - Uncompressing...'
 SPAWN,  'uncompress ' + file + ' >! /tmp/spefile.tmp'
 file = '/tmp/spefile.tmp'
ENDIF

IF N_ELEMENTS(lun) LE 0 THEN lun = -1	;Clean up
IF lun GT 0 THEN FREE_LUN, lun
OPENR,lun,file, ERROR = i, /GET_LUN, /BLOCK
IF i LT 0 THEN BEGIN 			; Something wrong, 
 IF lun GT 0 THEN FREE_LUN,lun
 lun = -1
 PRINT, 'Unable to open file: ' + file
 GOTO, nothing
ENDIF

;
; Get image sizes
;
IF N_ELEMENTS(rows) EQ 0 THEN rows = 1242
IF N_ELEMENTS(columns) EQ 0 THEN columns = 1152
IF N_ELEMENTS(offset) EQ 0 THEN offset = 0
IF N_ELEMENTS(swap) EQ 0 THEN swap = 0
IF N_ELEMENTS(n_bytes) EQ 0 THEN n_bytes = 2

image = LONARR(rows,columns, /NOZERO)
image_size = LONG(rows)*LONG(columns)



IF KEYWORD_SET(dump) OR (n_bytes EQ 4) THEN BEGIN
 POINT_LUN,lun,offset
 READU,lun,image
 IF swap EQ 0 THEN BEGIN
  IF !version.os EQ 'linux' THEN BYTEORDER,image,/LSWAP
 ENDIF ELSE BEGIN
  IF !version.os NE 'linux' THEN BYTEORDER,image,/LSWAP
 ENDELSE
 FREE_LUN,lun
 GOTO,orientation
ENDIF

IF n_bytes EQ 2 THEN BEGIN
 FREE_LUN, lun
 PRINT, 'Converting to Long Integer.'
 IF swap EQ 0 THEN BEGIN
  dummy = CALL_EXTERNAL(STRTRIM(GETENV('PROW_C')+'iq_lib.so'), 'no_swap', image, image_size, file, long(offset)) 
 ENDIF ELSE BEGIN
  dummy = CALL_EXTERNAL(STRTRIM(GETENV('PROW_C')+'iq_lib.so'), 'ii_swap', image, image_size, file, long(offset)) 
 ENDELSE
ENDIF

orientation :

IF NOT KEYWORD_SET(no_rotate) AND NOT KEYWORD_SET(beamline) THEN BEGIN
 PRINT,'Rotating image (top_display=right_image,towards source) ...'
 image=ROTATE(TEMPORARY(image),4)
 tmp=rows & rows=columns & columns=tmp
ENDIF

IF NOT KEYWORD_SET(no_rotate) AND KEYWORD_SET(beamline) THEN BEGIN
 PRINT,'Rotating image as in DIS (TOP=TOP, TOWARDS SOURCE)...'
 image=ROTATE(TEMPORARY(image),7)
ENDIF

;shall we erase previous windows ?
IF KEYWORD_SET(erase) THEN REPEAT WDELETE UNTIL !D.WINDOW EQ -1

;following trick gives the right window number on the title
IF KEYWORD_SET(display) THEN BEGIN
 WINDOW,!d.window+1,title=file+'  window:'+STRING(!D.WINDOW+1),xsize=rows/display,ysize=columns/display
 PRINT,'Displaying on window : ',!D.WINDOW
 IF display NE 1 THEN TVSCL,ALOG(REBIN(image,rows/display,columns/display)>1) ELSE TVSCL,alog(image>1)
ENDIF

PRINT, 'Done'
RETURN, image

nothing:
RETURN,0

end






















