function BACK2D_QUICK,array, percentage,dark_current,noise_index=noise_index,show=show
;+
; NAME:
;	BACK2D_QUICK
;
; PURPOSE:
;	Background removal by plane (polynomial) fitting
;
; CATEGORY:
;	Data processing.
;
; CALLING SEQUENCE:
;	back = BACK2D_QUICK(array,percentage,dark_current,[noise_index=noise_index,show=show])
;
; INPUTS:
;	array : the array to process
;	percentage : the initial percentage of the pixels to consider as noise. (the closer
;		this value to the real percentage, the faster the routine converges)
;	dark_current : the dark current of the detector (a constant offset)
;	show : keyword set to print info
;
; OUTPUTS:
;	back : the mean background.
;	noise_index : [optional] the indices of the pixels selected for
;		background calculation
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;	None.
;
; PROCEDURE:
;	Simple background evaluation without plane fitting.
;
; MODIFICATION HISTORY:
;	Dominique Bourgeois, June 95
;	Julien Bourgeoi, August 97
;-


arr_size=SIZE(array)
xsize=arr_size(1)
ysize=arr_size(2)
bc_mean = 0.0
;IF NOT(KEYWORD_SET(noise_index)) THEN noise_index = LONARR(((xsize*ysize)/4)/4*4)
noise_index = LONARR(xsize*ysize,/NOZERO)
IF KEYWORD_SET(show) THEN _show = long(1) ELSE _show = LONG(0)

dum = CALL_EXTERNAL(STRTRIM(GETENV('PROW_C')+'back2d_quick.so'),'back2d_quick', array, xsize, ysize, float(percentage),float(dark_current), long(_show), noise_index, bc_mean)

RETURN,bc_mean
END


