function BACK2D_POLY4,array, percentage,bg_gain,dark_current,bad_flag,coeff,bc_mean,n_back,chi_square_test,noise_index,show=show,max_cycle=max_cycle,max_slope=max_slope
;+
; NAME:
;	BACK2D_POLY4
;
; PURPOSE:
;	Background removal by plane (polynomial) fitting
;
; CATEGORY:
;	Data processing.
;
; CALLING SEQUENCE:
;	back = BACK2D_POLY4(array,percentage,bg_gain,dark_current,[bad_flag,coeff,
; 				chi_square_test,bc_mean,n_back],/show)
;
; INPUTS:
;	array : the array to process
;	percentage : the initial percentage of the pixels to consider as noise. (the closer
;		this value to the real percentage, the faster the routine converges)
;	bg_gain : the gain of the detector at the wavelength of the mean background.
;	dark_current : the dark current of the detector (a constant offset)
;	show : keyword set to print info
;	max_cycle : set this keyword to the maximum number of cycles allowed
;			(default = 100)
;	max_slope : set this keyword to the maximum slope allowed for 
;		background calculation (default = 5000)
;
; OUTPUTS:
;	bad_flag : (optionnal) this flag set to 1 if the chi_square test is not successfull
;	coeff : (optionnal) the coefficient of the background plane
;	chi_square_test : (optionnal) the chi_square test
;	bc_mean : [optional] the mean background
;	n_back : [optional] the number of pixels used for background 
;			subtraction
;	noise_index : [optional] the indices of the pixels selected for
;		background calculation
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;	None.
;
; PROCEDURE:
;	Taken from Rossman, J. App.
;	Cryst. (1979),12,225-238
;	The noise pixels which deviate too much from the fitted plane (more
;	than 1 times the variance) are taken away and the procedure
;	repeated until all noise pixels match the criteria.
;
; MODIFICATION HISTORY:
;	Dominique Bourgeois, June 95
;	Julien Bourgeoi, August 97
;-

IF KEYWORD_SET(max_cycle) THEN n_max_cycle = LONG(max_cycle) ELSE n_max_cycle = LONG(100)

IF KEYWORD_SET(max_slope) THEN n_max_slope = FLOAT(max_slope) ELSE n_max_slope = FLOAT(5000.)


s = SIZE(array) & xs = s(1) & ys = s(2)
n_back=0L
chi_square_test = 0.0
noise_index = LONARR(xs*ys,/NOZERO)
bc_mean = 0.0
bad_flag = 0L
coeff = FLTARR(3,/NOZERO)
array2=FLTARR(xs,ys,/NOZERO)
data=FLTARR(4,/NOZERO)

IF KEYWORD_SET(show) THEN _show = 1L ELSE _show = 0L

dummy = CALL_EXTERNAL(STRTRIM(GETENV('PROW_C')+'back2d_poly4.so'),'function',array, xs, ys, long(percentage), float(bg_gain), dark_current, _show,n_max_cycle,n_max_slope, coeff, noise_index, data, array2)

bad_flag = LONG(data(0))
chi_square_test = data(3)
bc_mean = data(1)
n_back = LONG(data(2))	

;IF bad_flag EQ 1 THEN BEGIN
; print,'Coeff are : ',coeff
; a=lonarr(21,21)
; a(noise_index)=1
; surface,a
; ok=''
; read,'ok',ok
;
;ENDIF

RETURN,array2
END




