#include "Types.h"
#include "Manip.h"

#include <math.h>
#include <stdio.h>

/* ARGUMENTS ARE :
   INPUTS
   argv[0]: profile (long array)
   argv[1]: peak_max (float)
   argv[2]: n_back (long)
   argv[3]: back (float)
   argv[4]: dark_current (float)
   argv[5]: bg_gain (float)
   argv[6]: gain (float)
   argv[7]: show ? (long (0 ou 1))
   argv[8]: xsize (long)
   argv[9]: ysize (long)
   
   OUTPUTS
   argv[10]: cutoff (float)
   */
   
void get_fitlevel(argc, argv)
int argc;
void *argv[];
{
  int i,j,k,count,p;
  int I;
  long xsize = *(long *) argv[8];
  long ysize = *(long *) argv[9];
  FArray prof;
  float* _image = (float *) argv[0];
  float max_prof = 0.0;
  float peak_max = *(float *)argv[1];
  long n_back  = *(long *) argv[2];
  float back = *(float*) argv[3];
  float dark_current = *(float *) argv[4];
  float bg_gain = *(float*) argv[5];
  float gain = *(float *) argv[6];
  long show = *(long *) argv[7];
  float min_sigma = (float) pow(10,10);
  float total = 0.0;
  float total_prof_carre = 0.0;
  float total_prof_carre_peak = 0.0;
  float sig_signal = 0.0;
  float sig_back = 0.0;
  float tmp2 = 0.0;
  float tmp1 = 0.0;
  float s0 = 0.0;
  float s1 = 0.0;
  float s2 = 0.0;
  FArray peak;
  float *res;
  float cutoff = 0.0;
  res = (float *) argv[10];
  
  /* je construit l'image */
  prof = CreateFArray(xsize,ysize);

  
  k = 0;
  for(i = 0; i < ysize; i++)
    {
      for(j = 0; j < xsize; j++)
	{
	  
	  prof.e[i][j] = (float) (1e-9 * ((long) (_image[k]*1e9))); 
	  /*  prof.e[i][j] = (float) _image[k]; */
	  /*     printf("before,after [%]:%30.20g\t%30.20g\n",_image[k],prof.e[i][j]); */
	  if (_image[k] > max_prof)
	    max_prof = _image[k];
	  k++;
	}
    }

  peak = CreateFArray(xsize,ysize);
  for(i = 0; i < ysize; i++)
    {
      for(j = 0; j < xsize; j++)
	{
	  peak.e[i][j] = gain * (prof.e[i][j]/max_prof)*(peak_max -back)+bg_gain*(back-dark_current);
	}
    }
  
  for(I = 0; I <= 20; I++)
    {
      count = 0;
      p = 0;
      total = 0.0;
      total_prof_carre_peak = 0.0;
      total_prof_carre = 0.0;
      for(i = 0; i < ysize; i++)
	{
	  for(j = 0; j < xsize; j++)
	    {
	      if (prof.e[i][j] >= (((float)max_prof)*((float)I)/100.0))
		{
		  total += ((float) prof.e[i][j]);
		  total_prof_carre_peak += sqr(((float)prof.e[i][j])) * peak.e[i][j];
		  total_prof_carre += sqr((float) prof.e[i][j]);
		  count++;
		}
	      p++;
	    }
	}

      sig_signal = total_prof_carre_peak/sqr(total_prof_carre);

      sig_back = bg_gain/((float)(n_back))*(back -
					    dark_current)*sqr(total)/sqr(total_prof_carre);
      tmp2 = s2;
      s2 = sig_signal+sig_back;
      tmp1 = s1;
      s1 = tmp2;;
      s0 = tmp1;

      if ((s2 > s1) && (s1 > s0) && (I >= 3))
	{
	  break;
	}
      if (s2 <= min_sigma)
	{
	  cutoff = (float) I;
	  min_sigma = s2;
	}
    }

  *res = fmax(cutoff,0.1);

  if (show)
    printf("Minimum sigma^2 [counts], Optimal cutoff [%]:%f\t%f\n",min_sigma,fmax(0.1,cutoff));

  FDelete(prof);
  FDelete(peak);

}












