function wheresub3,subscript,array; To convert a 1d subscript
;	to its position inside the 3d array
;+
; NAME:
;	WHERESUB3
;
; PURPOSE:
;	Convert a 1d subscript value or array of value to a pixel position 
;	in the 3d array, or to an array containing the ensemble of these
;	pixel position
;
; CATEGORY:
;	Signal, image processing.
;
; CALLING SEQUENCE:
;	Result = wheresub(subscript,array)
;
; INPUTS:
;	subscript: the subscript or array of subscripts to process
;	array:	The array where to locate the subscript
;
; OUTPUTS:
;	Result= the 3d pixel position, or an array[3,i] containing
;	the 3d pixel positions at position i.
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;	None.
;
; PROCEDURE:
;	Straightforward.
;
; MODIFICATION HISTORY:
;	D.Bourgeois, June  1995.
;-

on_error,2                              ;Return to caller if an error occurs
;check the size of subscript
size_sub=SIZE(subscript)

;get the size of the array
size_arr=SIZE(array)
IF size_arr(0) NE 3 THEN MESSAGE,'Not 3D array !'
sizex = size_arr(1)
sizey = size_arr(2)
sizez = size_arr(3)

IF size_sub(0) EQ 0 THEN BEGIN
pos=LONARR(3)
pos(2)=subscript/(sizex*sizey)
pos(1)=(subscript - pos(2)*sizex*sizey)/sizex
pos(0)=(subscript - pos(2)*sizex*sizey) - pos(1)*sizex
RETURN,pos
ENDIF

IF size_sub(0) EQ 1 THEN BEGIN
pos=LONARR(3,size_sub(1))
pos(2,*)=subscript/(sizex*sizey)
pos(1,*)=(subscript- pos(2,*)*sizex*sizey)/sizex
pos(0,*)=(subscript -pos(2,*)*sizex*sizey) - pos(1,*)*sizex
RETURN,pos
ENDIF


END


