pro SET_SECTORS, ref, par, show=show, win_id=win_id, reb_fac=reb_fac
;+
; NAME:
;	SET_SECTORS
;
; PURPOSE:
;	Give a sector number to each reflexion in ref. The various sectors are determined via
;	par.n_sectors.
;
; CATEGORY:
;	PROW integration.
;
; CALLING SEQUENCE:
;	SET_SECTORS,ref,par,[/show,win_id=win_id,reb_fac=reb_fac]
;
; INPUTS:
;	ref : the reflexion list. Must have a field called "sector".
;	par : the parameters of the experiment.
;	show : keyword set if the sectors are to be drawn.
;	win_id : window id of the main window displaying the image (if /show is set)
;	reb_fac : the rebinning factor for the displayed image (if /show is set)
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;	None.
;
; PROCEDURE:
;	Straightforward.	
;
; MODIFICATION HISTORY:
;	D.Bourgeois, March 1998.
;-

PRINT,'Numbers of selected sectors : ',par.n_sectors

at = ATAN(ref.y,ref.x)*180/!Pi
sq = SQRT(ref.x^2 + ref.y^2)

;give limits to all sectors
 all_phi_min=FLTARR(par.n_sectors)
 all_phi_max=FLTARR(par.n_sectors)
 all_min_r=FLTARR(par.n_sectors)
 all_max_r=FLTARR(par.n_sectors)
 max_r = SQRT(MAX(ref.x^2+ref.y^2))
 r_mean=max_r*2./3.
 phi_inc = 360./FLOAT(par.n_sectors/2.)

 FOR loc_i=0,par.n_sectors/2-1 DO BEGIN
  phi_min = loc_i*phi_inc
  phi_max = phi_min + phi_inc
  IF phi_min GT 180 THEN all_phi_min(loc_i) = phi_min - 360 ELSE all_phi_min(loc_i) = phi_min
  IF phi_max GT 180 THEN all_phi_max(loc_i) = phi_max - 360 ELSE all_phi_max(loc_i) = phi_max
;  IF phi_max GT 180 AND phi_max LT 360 THEN all_phi_max(loc_i) = phi_max - 360 ELSE all_phi_max(loc_i) = phi_max
  all_phi_min(loc_i+par.n_sectors/2) = all_phi_min(loc_i)
  all_phi_max(loc_i+par.n_sectors/2) = all_phi_max(loc_i)
  all_min_r(loc_i)=0
  all_min_r(loc_i+par.n_sectors/2)=r_mean
  all_max_r(loc_i)=r_mean
  all_max_r(loc_i+par.n_sectors/2)=max_r
 ENDFOR

IF KEYWORD_SET(show) THEN BEGIN ;show
 IF N_ELEMENTS(win_id) EQ 0 THEN win_id=!D.WINDOW
 IF N_ELEMENTS(reb_fac) EQ 0 THEN reb_fac=2
 WSET,win_id


 FOR loc_i=0,par.n_sectors-1 DO LAUE_DRAW_SEC,LONARR(par.rastx,par.rasty,/NOZERO),reb_fac,par,all_phi_min(loc_i),all_phi_max(loc_i),all_min_r(loc_i),all_max_r(loc_i)
ENDIF

FOR sec_i=0,par.n_sectors-1 DO BEGIN
 ;select the area of the sector

  IF all_phi_min(sec_i) LT all_phi_max(sec_i) THEN $
   w = WHERE( at LT all_phi_max(sec_i) AND $
		at GE all_phi_min(sec_i) AND $
		sq GE all_min_r(sec_i) AND $
		sq LE all_max_r(sec_i),n_ref) ELSE $
   w = WHERE( at LT all_phi_max(sec_i) OR $
		at GE all_phi_min(sec_i) AND $
		sq GE all_min_r(sec_i) AND $
		sq LE all_max_r(sec_i),n_ref)

 IF n_ref GT 0 THEN ref(w).sector=sec_i+1

ENDFOR
END
