function P6222_UNIQUE, ref, anomal=anomal
;+
; NAME: P6222_UNIQUE
;	
;
; PURPOSE:
;	Change indices hkl to the symmetry unique indices
;	as in CCP4. (Friedel pairs are treated as the same 
;	reflection unless the keyword ANOMAL is set.)
; 	For space group P6222 (No 180)
;	OPTION ANOMAL NOT SET AT THE MOMENT
;
; CATEGORY:
;	
;
; CALLING SEQUENCE:
;	unique = P6222_UNIQUE(ref [,anomal=anomal])
;
; INPUTS:
;	REF: The structure containing the reflections.
;	Must contain a tag "m" which is an array(3) of
;	the indices (hkl).  
;	ANOMAL: Keyword. If set and non-zero then bijvoet-pairs
;	are not treated as the same reflection.
;
; OUTPUTS:
;	The same structure where the indices have been changed
;	to be in one assymetric unit.	
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;
; PROCEDURE:
;
; MODIFICATION HISTORY:
;	Written by Dominique BOURGEOIS, December 1996
;-

on_error,2                              ;Return to caller if an error occurs

unique= ref

IF KEYWORD_SET(anomal) THEN MESSAGE,'Anomal KEYWORD option not working !'

sym=INTARR(3,24)
cr = STRING("15b)
refl_number = (size(ref))(1)

FOR i=0L,refl_number-1 DO BEGIN

  IF i/100 EQ i/100.0 THEN PRINT,FORMAT="($,I5,' ie : ',F3.0,'%',A)",i,100.*i/FLOAT(refl_number),cr

;all the symmetry were generated using the CCP4 program CAD.
h=ref(i).m(0)
k=ref(i).m(1)
l=ref(i).m(2)
sym(*,0)=[+h,+k,+l] 
sym(*,1)=[-h,-k,-l] 
sym(*,2)=[-h-k,+h,+l] 
sym(*,3)=[+h+k,-h,-l] 
sym(*,4)=[+k,-h-k,+l]
sym(*,5)=[-k,+h+k,-l]
sym(*,6)=[-h,-k,+l] 
sym(*,7)=[+h,+k,-l]
sym(*,8)=[+h+k,-h,+l]
sym(*,9)=[-h-k,+h,-l]
sym(*,10)=[-k,+h+k,+l] 
sym(*,11)=[+k,-h-k,-l]
sym(*,12)=[+k,+h,-l]  
sym(*,13)=[-k,-h,+l] 
sym(*,14)=[+h,-h-k,-l]
sym(*,15)=[-h,+h+k,+l]
sym(*,16)=[-h-k,+k,-l]  
sym(*,17)=[+h+k,-k,+l]  
sym(*,18)=[-k,-h,-l]
sym(*,19)=[+k,+h,+l]
sym(*,20)=[-h,+h+k,-l]
sym(*,21)=[+h,-h-k,+l]
sym(*,22)=[+h+k,-k,-l]
sym(*,23)=[-h-k,+k,+l]

w=where((sym(0,*) GE 0) AND (sym(1,*) GE 0) AND (sym(2,*) GE 0) AND ((sym(0,*)-sym(1,*)) GE 0),ct)

unique(i).m(0) = sym(0,w(0))
unique(i).m(1) = sym(1,w(0))
unique(i).m(2) = sym(2,w(0))

ENDFOR

RETURN, unique

END