function INTERSEC_TU, arr1,arr2,ct,arr3,sym=sym,unique=unique, $
		sep_unique=sep_unique, $
		un1=un1, ct1=ct1, un2=un2, ct2=ct2
;+
; NAME:
;	INTERSEC_TU
;
; PURPOSE:
;	Returns the intersection (common spots) between ARR1 and ARR2
;	and possibly also those that occur only in one of the arrays.
;	in the form of ARR1. (See below.)
;	If one reflection exists several times the last will be returned
;	(in the result and in ARR3 if present). See however keyword SYM.
;
; CATEGORY:
;	Structure managing
;
; CALLING SEQUENCE:
;	InterStruc= INTERSEC_TU(arr1,arr2[, ct, arr3, /SYM, /UNIQUE, $
;			/SEP_UNIQUE, $
;			un1=un1, ct1=ct1, $
;			un2=un2, ct2=ct2]) 
;
; INPUTS:
;	ARR1,2 : The arrays to process
;
; OUTPUTS:
;	The part of ARR1 matching the intersection between the input 
;	structures. The output is sorted on Miller indices if UNIQUE is not
;	set. (ARR3 also sorted if the result is sorted.)
;	CT: [optional] The number of coomon reflections. (Note that this is
;		not the total number of returned reflections if UNIQUE is set.)
;	ARR3: [optional] If given then ARR3 contains on output
;		the same spots as the result (only the
;		common ones if UNIQUE is set) but copied from ARR2. If UNIQUE
;		is set then the spots in ARR3 corresponds to the (size(arr3)(1)
;		first spots in the result.
;	UN1,UN2: The unique reflections in ARR1 and ARR2 (if
;		UNIQUE or SEP_UNIQUE is set).
;	CT1,CT2: The number of unique reflections in ARR1 and ARR2 
;		respectively (if UNIQUE or SEP_UNIQUE keyword is set).
;
; KEYWORDED INPUT:
;	SYM: Set this keyword if arr1 is likely to contain several times
;		the same miller indices (for exemple if P212121_UNIQUE has
;		been run on arr1). In this case the result contains the 
;		reflections in ARR1 that has a corresponding reflection 
;		in ARR2 but ARR3 will only contain the first reflection 
;		in ARR2 of each miller index even if there happen to be 
;		several. ARR3 will still be of the same size as the result 
;		but for the "multiples" in ARR1 the same reflection in ARR2 
;		will simply be repeated.
;
;	UNIQUE: If set then also those reflections appearing in only one 
;		array are returned. NOTE: The types of ARR1 and ARR2 must
;		be the same in this case! Those reflections appearing in 
;		only one array are returned in UN1 and UN2.
;
;	SEP_UNIQUE: If set then those reflections appearing in only one 
;		array are returned in UN1 and UN2. (Use instead
;		of UNIQUE if ARR1 and ARR2 are not of the same type.)
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;
; PROCEDURE:
;	Straightforward
;
; MODIFICATION HISTORY:
;	D.Bourgeois, June 95.
;	T.Ursby, June 95.
;-

;on_error,2                              ;Return to caller if an error occurs

;produce the right number of reflections
size1 = (SIZE(arr1))(1)
size2 = (SIZE(arr2))(1)

max_size = size1 > size2

h1 = arr1.m(0) & k1 = arr1.m(1) & l1 = arr1.m(2)
h2 = arr2.m(0) & k2 = arr2.m(1) & l2 = arr2.m(2)

max_hkl = MAX([h1,k1,l1]) > MAX([h2,k2,l2])
min_hkl = MIN([h1,k1,l1]) < MIN([h2,k2,l2])

;grid will be set to 3 if there is a common reflection
grid = BYTARR(max_hkl - min_hkl + 1,max_hkl - min_hkl + 1,max_hkl - min_hkl + 1)
;i1 contains the indices in arr1 associated with each (h,k,l)
i1 =  LONARR(max_hkl - min_hkl + 1,max_hkl - min_hkl + 1,max_hkl - min_hkl + 1)

grid(h1 - min_hkl,k1 - min_hkl,l1 - min_hkl) = 1
i1(h1 - min_hkl,k1 - min_hkl,l1 - min_hkl) = LINDGEN(size1)
grid(h2 - min_hkl,k2 - min_hkl,l2 - min_hkl) = grid(h2 - min_hkl,k2 - min_hkl,l2 - min_hkl) + 2

IF (KEYWORD_SET(unique) OR KEYWORD_SET(sep_unique) $
	OR (N_PARAMS() eq 4)) THEN BEGIN
  ;i2 contains the indices in arr2 associated with each (h,k,l)
  i2 =  LONARR(max_hkl - min_hkl + 1,max_hkl - min_hkl + 1, $
	max_hkl - min_hkl + 1)
  i2(h2 - min_hkl,k2 - min_hkl,l2 - min_hkl) = INDGEN(size2)
ENDIF

w = WHERE(grid EQ 3,ct)

IF ct NE 0 THEN BEGIN
  ; Find reflections that occur several times in ARR1?
  IF KEYWORD_SET(sym) THEN BEGIN
    final = REPLICATE(arr1(0),size1)
    IF (N_PARAMS() eq 4) THEN BEGIN
      arr30= arr2(i2(w))
      arr3 = REPLICATE(arr2(0),size1)
    ENDIF
    j = 0
    cr = STRING("15b)
    FOR i=0,ct-1 DO BEGIN
      IF i/100 EQ i/100.0 THEN PRINT,FORMAT="($,I5,' ie : ',F3.0,'%',A)", $
	i,100.*i/FLOAT(ct),cr
      wl = WHERE((arr1.m(0) EQ arr1(i1(w(i))).m(0)) AND $
		(arr1.m(1) EQ arr1(i1(w(i))).m(1)) AND $
		(arr1.m(2) EQ arr1(i1(w(i))).m(2)),ctl)
      final(j:j+ctl-1) = arr1(wl)
      IF (N_PARAMS() eq 4) THEN arr3(j:j+ctl-1)= REPLICATE(arr2(i2(w(i))),ctl)
      j = j + ctl
    ENDFOR
    final = final(0:j-1)
    IF (N_PARAMS() eq 4) THEN arr3= arr3(0:j-1)
    ct = (SIZE(final))(1)
  ENDIF ELSE BEGIN
    final = arr1(i1(w))
    final = final(*)
    IF (N_PARAMS() eq 4) THEN arr3= arr2(i2(w))
  ENDELSE

  ; Add reflections that occur only in one of the arrays:
  IF KEYWORD_SET(unique) THEN BEGIN
    ctot=ct
    w = final
    final = REPLICATE(arr1(0),size1+size2)
    final(0:ct-1) = w
    w = WHERE(grid EQ 1,ct1)
    IF (ct1 gt 0) THEN final(ctot:ctot+ct1-1)= arr1(i1(w))     
    IF (ct1 gt 0) THEN un1= arr1(i1(w))
    ctot=ctot+ct1
    w = WHERE(grid EQ 2,ct2)
    IF (ct2 gt 0) THEN final(ctot:ctot+ct2-1)= arr2(i2(w))     
    IF (ct2 gt 0) THEN un2= arr2(i2(w))
    ctot=ctot+ct2
    final = final(0:ctot-1)
  ENDIF ELSE IF KEYWORD_SET(sep_unique) THEN BEGIN
    w = WHERE(grid EQ 1,ct1)
    IF (ct1 gt 0) THEN un1= arr1(i1(w))
    w = WHERE(grid EQ 2,ct2)
    IF (ct2 gt 0) THEN un2= arr2(i2(w))
  ENDIF

  IF (((SIZE(final))(1) GT 1) AND (NOT KEYWORD_SET(unique))) THEN BEGIN
    IF (N_PARAMS() eq 4) THEN BEGIN
      SORT_MILLER,final
      SORT_MILLER,arr3
    ENDIF ELSE SORT_MILLER,final
  ENDIF
  PRINT,'Total number of common reflections',ct
  IF (KEYWORD_SET(unique) or KEYWORD_SET(sep_unique))THEN BEGIN
    PRINT, 'Unique reflections in array 1:',ct1
    PRINT, 'Unique reflections in array 2:',ct2
  ENDIF
  RETURN,final
ENDIF ELSE RETURN,0

END

