function GET_OVLPV, struc1,lambda1,par
;+
; NAME:
;	GET_OVLPV
;
; PURPOSE:
;	Returns the auto-covariance for one peak which is overlapped with 
;	some others. The peak is defined with struc1. The structure
;	must contain the fields "indices" and "adapted_profile" and "area" 
;	and "bc_coeff", and "background".
;	The sorting is done according to "indices".
;
; CATEGORY:
;	Structure managing
;
; CALLING SEQUENCE:
;	covar = GET_OVLPV(struc1,lambda1,par) ;
;
; INPUTS:
;	struc1 : the structures to process. These are structures, not array
;		of structures.
;	lambda1 : wavelength for the first peak [A]
;	par : parameters of the experiment
;
; OUTPUTS:
;	var : The auto-covariance
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;
; PROCEDURE:
;	The auto_covariance is expressed as : 
;	covar = gain*(SUM_OVER_PIXEL_INDICES[adapted_profile1^2*
;	background_subtracted_pixel_value]) + background_gain*
;	(SUM_OVER_PIXEL_INDICES[adapted_profile1^2*background_pixel_value] + 
;	(SUM_OVER_PIXEL_INDICES[adapted_profile1])^2*mean_background1/nb1
;	And nb1 is the number of pixels used to determine the
;	background level.
;
;
; MODIFICATION HISTORY:
;	D.Bourgeois, Mars 97.
;-

;on_error,2                              ;Return to caller if an error occurs

;number of pixels to process
;w1 = WHERE(*struc1.indices GT 0,num_pixel1)

gain =  par.gain*1.5418/lambda1
bg_gain = par.bg_gain

;var = gain*TOTAL(struc1.adapted_profile((*struc1.peak_area)(w1))^2*struc1.area((*struc1.peak_area)(w1))) + bg_gain*(TOTAL(struc1.adapted_profile((*struc1.peak_area)(w1))^2*struc1.background((*struc1.peak_area)(w1))) + TOTAL(struc1.adapted_profile((*struc1.peak_area)(w1)))^2*(struc1.bc_coeff(2)-par.dark_current)/struc1.bc_coeff(1))

var = gain*TOTAL(struc1.adapted_profile(*struc1.peak_area)^2*struc1.area(*struc1.peak_area)) + bg_gain*(TOTAL(struc1.adapted_profile(*struc1.peak_area)^2*struc1.background(*struc1.peak_area)) + TOTAL(struc1.adapted_profile(*struc1.peak_area))^2*(struc1.bc_coeff(2)-par.dark_current)/(struc1.bc_coeff(1)>1))
RETURN,var

END

