function GET_ENLARGED_REGION,region,x,y,extend=extend,reverse=reverse,up_right=up_right,show=show
;+
; NAME:
;	GET_ENLARGED_REGION
;
; PURPOSE:
;	Get an extended region in a box of size x*y. Region is the original region, extend is the 
;	amount of extension. 
;
; CATEGORY:
;	Data processing
;
; CALLING SEQUENCE:
;	enlarged_region = GET_ENLARGED_REGION(region,x,y,[extend=extend, reverse=reverse, up_right=up_right][,/show])
;
; INPUTS:
;	region : the original input region (a 1D LONARR)
;	x : the x size of the box
;	y : the y size of the box
;	extend : [optional] the amount of extension [in pixels]. Default : 1
;	reverse : [optional] use this keyword to return the complementary region of region,
;		extended by the right amount.
;	up_right : [optional] set this keyword to only extend the upper right region.
;	show : set this keyword to show information
;
; OUTPUTS:
;	enlarged_region : the enlarged region (1D LONARR)
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;	None
;
; PROCEDURE:
;	Sort of straightfroward.
;
; MODIFICATION HISTORY:
;	D.Bourgeois, March 1998.
;-

IF N_ELEMENTS(extend) EQ 0 THEN extend=1
IF extend EQ 0 THEN BEGIN
 IF KEYWORD_SET(reverse) THEN BEGIN
  ;define a box
  gen_reg=LONARR(x,y,/NOZERO) 
  gen_reg(*)=1
  gen_reg(region)=0
  enlarged_region=WHERE(gen_reg EQ 1)
  RETURN,enlarged_region
 ENDIF ELSE BEGIN
  RETURN,region
 ENDELSE
ENDIF

IF KEYWORD_SET(reverse) THEN BEGIN
 ;define a box
 gen_reg=LONARR(x,y,/NOZERO) 
 gen_reg(*)=1
 gen_reg(region)=0
ENDIF ELSE BEGIN
 ;define a box
 gen_reg=LONARR(x,y) 
 gen_reg(region)=1
ENDELSE

IF KEYWORD_SET(show) THEN BEGIN
 SURFACE,gen_reg
 ok=''
 READ,'Ok ?',ok
ENDIF

FOR k=0,extend-1 DO BEGIN
 ;first increase the right border (and possibly left)
 w_reg=WHERE(gen_reg EQ 1,ct_reg)
 IF ct_reg EQ 0 THEN MESSAGE,'Region is empty !'
 ;the x,y coordinates of the region are :
 xy_reg = WHERESUB(w_reg,gen_reg)	
 min_v = MIN(IMAGINARY(xy_reg)) & max_v = MAX(IMAGINARY(xy_reg))
 FOR j=min_v,max_v DO BEGIN
  w=WHERE(IMAGINARY(xy_reg) EQ j,ct)
  IF ct GE 1 THEN BEGIN
   gen_reg((MAX(FLOAT(xy_reg(w)))+1)<(x-2),j)=1 
   IF NOT KEYWORD_SET(up_right) THEN gen_reg((MIN(FLOAT(xy_reg(w)))-1)>1,j)=1 
  ENDIF ELSE $
   MESSAGE,'Region is discontinue ! Cannot treat this case !'
 ENDFOR

 IF KEYWORD_SET(show) THEN BEGIN
  SURFACE,gen_reg
  ok=''
  READ,'Ok ?',ok
 ENDIF

 ;then increase the upper border (and possibly lower)
 w_reg=WHERE(gen_reg EQ 1,ct_reg)
 ;the x,y coordinates of the region are :
 xy_reg = WHERESUB(w_reg,gen_reg)	
 min_v = MIN(FLOAT(xy_reg)) & max_v = MAX(FLOAT(xy_reg))
 FOR j=min_v,max_v DO BEGIN
  w=WHERE(FLOAT(xy_reg) EQ j,ct) 
  IF ct GE 1 THEN BEGIN
   gen_reg(j,(MAX(IMAGINARY(xy_reg(w)))+1)<(y-2))=1 
   IF NOT KEYWORD_SET(up_right) THEN gen_reg(j,(MIN(IMAGINARY(xy_reg(w)))-1)>1)=1 
  ENDIF  ELSE $
   MESSAGE,'Region is discontinue ! Cannot treat this case !'
 ENDFOR

 IF KEYWORD_SET(show) THEN BEGIN
  SURFACE,gen_reg
  ok=''
  READ,'Ok ?',ok
 ENDIF

ENDFOR

enlarged_region = WHERE(gen_reg EQ 1)
RETURN,enlarged_region
END








