function GET_CORREL2, struc1,struc2,j,wcom1,wcom2
;+
; NAME:
;	GET_CORREL2
;
; PURPOSE:
;	Returns the sum of the products of the common pixel values between
;	struc1 and struc2. The structures
;	must contain the fields "indices" and "adapted_profile"
;	The sorting is done according to "indices".
;
; CATEGORY:
;	Structure managing
;
; CALLING SEQUENCE:
;	tot = GET_CORREL2(struc1,struc2,j) ;
;
; INPUTS:
;	struc1,2 : the structures to process. These are structures, not array
;		of structures.
;
; OUTPUTS:
;	tot : The sum of the products of the common pixel values between
;	struc1 and struc2.
;	j : [optionnal] returns the number of common pixels
;	wcom1 : [optional] struc1.indices(wcom1) contains the indices of the common pixels
;	wcom2 : [optional] struc2.indices(wcom2) contains the indices of the common pixels
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;
; PROCEDURE:
;	Straightforward
;
; MODIFICATION HISTORY:
;	D.Bourgeois, May 95.
;-

;on_error,2                              ;Return to caller if an error occurs


wcom1 = INTARR(struc1.count,/NOZERO)
wcom2 = INTARR(struc2.count,/NOZERO)

final = {adap_pro1 : FLTARR(struc1.count,/NOZERO),adap_pro2 : FLTARR(struc2.count,/NOZERO)}
j = 0

;Check the intersection between struc1.indices and struc2.indices

FOR i=0,struc2.count-1 DO BEGIN
 index = WHERE(*struc1.indices EQ (*struc2.indices)(i), count)

 IF count NE 0 THEN BEGIN
    final.adap_pro1(j) = struc1.adapted_profile((*struc1.peak_area)(index))
    final.adap_pro2(j) = struc2.adapted_profile((*struc2.peak_area)(i))
    wcom1(j) = index(0)
    wcom2(j) = i
   j = j + 1
 ENDIF
ENDFOR

;PRINT,'Number of common pixels : ',j
;PRINT,'Percentage : ', 100*j/FLOAT(num_pixel)
;plot,final.adap_pro1(0:j-1)
;oplot,final.adap_pro2(0:j-1),linestyle=2
;OK=''
;PRINT,'OK ? [Y/N]'
;READ,OK

IF j GT 0 THEN BEGIN
 wcom1 = wcom1(0:j-1)
 wcom2 = wcom2(0:j-1)
 RETURN,TOTAL(final.adap_pro1(0:j-1)*final.adap_pro2(0:j-1))
ENDIF ELSE RETURN,0.

END

