function GET_COMMON_ELEMENTS, array1,array2,j=j
;+
; NAME:
;	GET_COMMON_ELEMENTS
;
; PURPOSE:
;	Returns the location of the common pixel values between
;	array1 and array2.
;
; CATEGORY:
;	Array managing
;
; CALLING SEQUENCE:
;	w = GET_COMMON_ELEMENTS(array1,array2,j=j) ;
;
; INPUTS:
;	array1,2 : the arrays to process. 
;
; OUTPUTS:
;	w : The indices of array1 common to array2.
;	j : [optionnal] returns the number of common pixels
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;
; PROCEDURE:
;	Straightforward
;
; MODIFICATION HISTORY:
;	D.Bourgeois, December 99.
;-

;on_error,2                              ;Return to caller if an error occurs

;number of pixels to process
IF ((SIZE(array1))(0) EQ 0) OR ((SIZE(array2))(0) EQ 0) THEN BEGIN
;one array has only 1 elements
 IF MIN(ABS(array2 - array1)) EQ 0 THEN BEGIN
  j=1
  IF ((SIZE(array1))(0) EQ 0) THEN RETURN,array1
  IF ((SIZE(array2))(0) EQ 0) THEN RETURN,array2
 ENDIF ELSE BEGIN
  PRINT,'There is no common elements !'
  RETURN,'There is no common elements !'
 ENDELSE
ENDIF

;the two arrays have more than 1 elements
IF MIN(array1) LT 0 OR MIN(array2) LT 0 THEN MESSAGE,'Input arrays must contain positive values !'
IF MAX(array1) GT 100000L OR MAX(array2) GT 100000L THEN MESSAGE,'Input arrays must contain values less than 100000 !'
s1=MAX(array1) & s2=MAX(array2)

max_s = s1>s2 
range_array = BYTARR(max_s+1)
range_array(array1)=1
range_array(array2)=range_array(array2)+1
common_elem=WHERE(range_array EQ 2,ct_common)
j=ct_common
IF ct_common EQ 0 THEN PRINT,'No common elemnts !'
RETURN,common_elem

END






