FUNCTION GET_BEST_OVLP_PROFILE,cara_spot,w_max_corr,SHOW=SHOW

sx=(SIZE(cara_spot.adapted_profile))(1) & sy=(SIZE(cara_spot.adapted_profile))(2)

p = CONGRID(cara_spot.adapted_profile,4*sx,4*sy,/CUBIC)

orig_xind = REPLICATE(1,sx) # INDGEN(sy)*16*sx
orig_yind = INDGEN(sx)*4 # REPLICATE(1,sy)
orig_ind=orig_xind + orig_yind 

corr_area=*cara_spot.peak_area
IF cara_spot.ncom GT 0 THEN corr_area(cara_spot.wcom(0:cara_spot.ncom-1))=0
corr_area=corr_area(WHERE(corr_area NE 0))

n=0
i2=0 & j2=0

IF (SIZE(corr_area))(1) LT 2 THEN BEGIN
	;don't do anything
	adapted_profile2 = p(orig_ind)
	GOTO,got_it
ENDIF


REPEAT BEGIN

corr_array = [ $

CORRELATE((p(orig_ind))(corr_area), cara_spot.area(corr_area)) , $ ; move x 0 y 0
CORRELATE((p(orig_ind+4*sx))(corr_area), cara_spot.area(corr_area)) , $  ; move x 0 y -0.25
CORRELATE((SHIFT(p(orig_ind+12*sx),0,1))(corr_area), cara_spot.area(corr_area)) , $  ; move x 0 y 0.25

CORRELATE((p(orig_ind+1))(corr_area), cara_spot.area(corr_area)) , $  ; move x -0.25 y 0
CORRELATE((p(orig_ind+4*sx+1))(corr_area), cara_spot.area(corr_area)) , $  ; move x  -0.25 y -0.25
CORRELATE((SHIFT(p(orig_ind+12*sx+1),0,1))(corr_area), cara_spot.area(corr_area)) , $  ; move x -0.25 y 0.25

CORRELATE((SHIFT(p(orig_ind+3),1,0))(corr_area), cara_spot.area(corr_area)) , $  ; move x 0.25 y 0
CORRELATE((SHIFT(p(orig_ind+4*sx+3),1,0))(corr_area), cara_spot.area(corr_area)) , $  ; move x 0.25 y -.25
CORRELATE((SHIFT(p(orig_ind+12*sx+3),1,1))(corr_area), cara_spot.area(corr_area))  $  ; move x 0.25 y 0.25

	    ]


;find the maximum
w_max_corr=(WHERE(corr_array EQ MAX(corr_array)))(0)
CASE w_max_corr OF 

 0 : BEGIN
	adapted_profile2 = p(orig_ind)
	GOTO,got_it
     END

 1 : BEGIN
	i=0 & j=-1 
     END

 2 : BEGIN
	i=0 & j= 1
     END

 3 : BEGIN
	i=-1 & j= 0 & i2=i2+i & j2=j2+j
     END

 4 : BEGIN
	i=-1 & j=-1 & i2=i2+i & j2=j2+j
     END

 5 : BEGIN
	i=-1 & j= 1 & i2=i2+i & j2=j2+j
     END

 6 : BEGIN
	i= 1 & j= 0 & i2=i2+i & j2=j2+j
     END

 7 : BEGIN
	i= 1 & j=-1 & i2=i2+i & j2=j2+j
     END

 8 : BEGIN
	i= 1 & j= 1 & i2=i2+i & j2=j2+j
     END

ENDCASE

d=0.25*SQRT(i2^2+j2^2)
p=SHIFT(p,i,j)
n=n+1

IF KEYWORD_SET(show) THEN BEGIN
 PRINT,'Initial correlation : ',corr_array(0)
 PRINT,'Final correlation : ',corr_array(w_max_corr)
 CASE w_max_corr OF 
  0 : PRINT,'moved x 0 y 0'
  1 : PRINT,'moved x 0 y -0.25'
  2 : PRINT,'moved x 0 y 0.25'
  3 : PRINT,'moved x -0.25 y 0'
  4 : PRINT,'moved x -0.25 y -0.25'
  5 : PRINT,'moved x -0.25 y 0.25' 
  6 : PRINT,'moved x 0.25 y 0 '
  7 : PRINT,'moved x 0.25 y -0.25'
  8 : PRINT,'moved x 0.25 y 0.25'
 ENDCASE
 PRINT,'Distance to original position [raster] : ',d

ENDIF


ENDREP UNTIL n EQ 4


CASE w_max_corr OF 

 1 : BEGIN
	adapted_profile2 = p(orig_ind+4*sx) ; move x 0 y -0.25
	GOTO,got_it
     END

 2 : BEGIN
	adapted_profile2 = SHIFT(p(orig_ind+12*sx),0,1) ; move x 0 y 0.25
	GOTO,got_it
     END


 3 : BEGIN
	adapted_profile2 = p(orig_ind+1) ; move x -0.25 y 0
	GOTO,got_it
     END

 4 : BEGIN
	adapted_profile2 = p(orig_ind+4*sx+1) ; move x  -0.25 y -0.25
	GOTO,got_it
     END


 5 : BEGIN
	adapted_profile2 = SHIFT(p(orig_ind+12*sx+1),0,1) ; move x -0.25 y 0.25
	GOTO,got_it
     END


 6 : BEGIN
	adapted_profile2 = SHIFT(p(orig_ind+3),1,0) ; move x 0.25 y 0
	GOTO,got_it
     END

 7 : BEGIN
	adapted_profile2 = SHIFT(p(orig_ind+4*sx+3),1,0) ; move x 0.25 y -.25
	GOTO,got_it
     END

 8 : BEGIN
	adapted_profile2 = SHIFT(p(orig_ind+12*sx+3),1,1) ; move x 0.25 y 0.25
	GOTO,got_it
     END

ENDCASE

got_it:

IF KEYWORD_SET(show) THEN BEGIN
 PRINT,'OVLP SPOT :'
 PRINT,'Original adapted profile + original profile : '
 temp = cara_spot.adapted_profile
 temp(*) = 0
 temp(*cara_spot.peak_area) = cara_spot.adapted_profile(*cara_spot.peak_area)
 CONTOUR,temp,LEVELS=[(INDGEN(10)+1)*MAX(temp)/10.],C_COLORS=!D.N_COLORS - 150
 CONTOUR,cara_spot.area,LEVELS=[(INDGEN(10)+1)*MAX(cara_spot.area)/10.],/NOERASE,C_COLORS=!D.N_COLORS - 60

 OK=''
 READ,'OK ? [Y/N]',OK

 PRINT,'Original adapted profile + original profile  (correlation area) : '
 temp = cara_spot.adapted_profile
 temp(*) = 0
 temp2 = cara_spot.area
 temp2(*) = 0

 temp(corr_area) = cara_spot.adapted_profile(corr_area)
 temp2(corr_area) = cara_spot.area(corr_area)

 CONTOUR,temp,LEVELS=[(INDGEN(10)+1)*MAX(temp)/10.],C_COLORS=!D.N_COLORS - 150
 CONTOUR,temp2,LEVELS=[(INDGEN(10)+1)*MAX(temp2)/10.],/NOERASE,C_COLORS=!D.N_COLORS - 60

 READ,'OK ? [Y/N]',OK

 PRINT,'Final adapted profile + original profile : '
 temp = adapted_profile2
 temp(*) = 0
 temp(*cara_spot.peak_area) = adapted_profile2(*cara_spot.peak_area)
 CONTOUR,temp,LEVELS=[(INDGEN(10)+1)*MAX(temp)/10.],C_COLORS=!D.N_COLORS - 150
 CONTOUR,cara_spot.area,LEVELS=[(INDGEN(10)+1)*MAX(cara_spot.area)/10.],/NOERASE,C_COLORS=!D.N_COLORS - 60

 READ,'OK ? [Y/N]',OK

 PRINT,'Final adapted profile + original profile  (correlation area) : '
 temp = adapted_profile2
 temp(*) = 0
 temp2 = cara_spot.area
 temp2(*) = 0

 temp(corr_area) = adapted_profile2(corr_area)
 temp2(corr_area) = cara_spot.area(corr_area)

 CONTOUR,temp,LEVELS=[(INDGEN(10)+1)*MAX(temp)/10.],C_COLORS=!D.N_COLORS - 150
 CONTOUR,temp2,LEVELS=[(INDGEN(10)+1)*MAX(temp2)/10.],/NOERASE,C_COLORS=!D.N_COLORS - 60

 OK=''
 READ,'OK ? [Y/N]',OK

ENDIF

RETURN,adapted_profile2
END


