function DIFF_STRUC, struc1,struc2
;+
; NAME:
;	DIFF_STRUC
;
; PURPOSE:
;	Returns the difference between struc1 and struc 2 using the field .id
;
; CATEGORY:
;	Structure managing
;
; CALLING SEQUENCE:
;	InterStruc = DIFF_STRUC(struc1,struc2) ;
;
; INPUTS:
;	struc1,2 : the structures to process
;
; OUTPUTS:
;	the part of struc1 which is not struc2
;
; COMMON BLOCKS:
;	None.
;
; SIDE EFFECTS:
;	None.
;
; RESTRICTIONS:
;	The structures must contain a field .id
;
; PROCEDURE:
;	Straightforward
;
; MODIFICATION HISTORY:
;	D.Bourgeois, February 95.
;-

;on_error,2                              ;Return to caller if an error occurs

one_refl=struc1(0)

;produce the right number of reflections
size1 = (SIZE(struc1))(1)
size2 = (SIZE(struc2))(1)

id1 = struc1.id & id2 = struc2.id

max_id = MAX(id1) > MAX(id2)
min_id = MIN(id1) < MIN(id2)

;i1 contains the indices in struc1 associated with each id
i1 =  LONARR(max_id - min_id + 1)
i1(*) = -1
i1(id1 - min_id) = LINDGEN(size1)
i1(id2 - min_id) = -1

w = WHERE(i1 GE 0,ct)

IF ct NE 0 THEN BEGIN
diff_id = w

w = i1(w)

final = struc1(w)
final = final(*)

ct = (SIZE(final))(1)
;PRINT,'Total number of weak reflections',ct
RETURN,final
ENDIF ELSE RETURN,0

END

