Function Type, x, Verbose=verbose

;+
; NAME:
;	TYPE
; PURPOSE:
;	Finds the type class of a variable.
; CATEGORY:
;	Programming.
; CALLING SEQUENCE:
;	Result = TYPE(X)
; INPUTS:
;    X
;	Arbitrary, doesn't even need to be defined.
; OPTIONAL INPUT PARAMETERS:
;	None.
; KEYWORD PARAMETERS:
;	VERBOSE: When this keyword is set, returns a string with 
;		the variable type name, as defined in the following
;		table. 
; OUTPUTS:
;	Returns the type of X as a long integer, in the (0,15) range:
;	0	Undefined	
;	1	Byte	
;	2	Integer	
;	3	Longword integer	
;	4	Floating point	
;	5	Double-precision floating
;	6	Complex floating	
;	7	String	
;	8	Structure	
;	9	Double-precision complex	
;	10	Pointer	
;	11	Object reference	
;	12	Unsigned Integer	
;	13	Unsigned Longword Integer	
;	14	64-bit Integer	
;	15	Unsigned 64-bit Integer	
;
;
; OPTIONAL OUTPUT PARAMETERS:
;	None.
; COMMON BLOCKS:
;	None.
; SIDE EFFECTS:
;	None.
; RESTRICTIONS:
;	None.
; PROCEDURE:
;	Extracts information from the SIZE function.
; MODIFICATION HISTORY:
;	Created 15-JUL-1991 by Mati Meron.
;	99-01-19 srio@esrf.fr updates doc, adds /Verbose keyword.
;	00-01-10 srio@esrf.fr removes blanks in labels
;-

    dum = size(x)
    IF Keyword_Set(verbose) THEN BEGIN
	CASE dum(dum(0) + 1) OF
	 0: name = 'Undefined'
	 1: name = 'Byte'
	 2: name = 'Integer'
	 3: name = 'Longword integer'	
	 4: name = 'Floating point'	
	 5: name = 'Double-precision floating'
	 6: name = 'Complex floating'	
	 7: name = 'String'	
	 8: name = 'Structure'	
	 9: name = 'Double-precision complex'	
	 10: name = 'Pointer'	
	 11: name = 'Object reference'	
	 12: name = 'Unsigned Integer'	
	 13: name = 'Unsigned Longword Integer'	
	 14: name = '64-bit Integer'	
	 15: name = 'Unsigned 64-bit Integer'	
         else: name = 'Unknown'
	ENDCASE
	RETURN,name
    ENDIF ELSE return, dum(dum(0) + 1)
end
