PRO myidlmacro, file, group=group, buffer=buffer, noedit=noedit

;+
; NAME:
;	MyIdlMacro
;
; PURPOSE:
;	Executes sequential IDL commands from a file, or from a variable.
;
; CATEGORY:
;	Utilities. Widgets.
;
; CALLING SEQUENCE:
;	myidlmacro [,file]
;
;
; OPTIONAL INPUTS:
;	file:	The name of the file containing the commands to be executed.
;		If this input is not set, the applications starts a text
;		window where the commands may be enteres or read from a file.
;	
; KEYWORD PARAMETERS:
;	BUFFER = a text buffer containing the commands to be executed.
;		If set, the optional input "file" is irrelevant.	
;	NOEDIT = when set, executes the commands in "BUFFER" or in "FILE"
;		without presenting them in a window for editing.
;       GROUP = The widget ID of the widget that calls MyIdlMacro.
;       	When this ID is specified, a death of the caller results
;       	in a death of widgets created by MyIdlMacro.
;
; OUTPUTS:
;	None.
;
;
; RESTRICTIONS:
;       It is possible to use variables in the buffer, but this variables
;       must have a name included in the list: a0,...a9,b0,...b9,
;       c0,...,c9,d0,...,d9 (this is due to the fact that EXECUTE cannot 
;	create variables on the fly. The variable must be pre-initializad.
;	The comands are executed using "EXECUTE" commands, thus apply all the
;	limitations of this function (i.e. no command splitting in two
;	lines, no programming blocks, etc.)
;
; PROCEDURE:
;	Reads the input variable/file and executes the commands.
;
; EXAMPLE:
;	; starts with default
;	myidlmacro
;
;	;example using a file
;	openw,Unit,'tmp',/get_lun
;	printf,unit,'a0=dist(10)'
;	printf,unit,'surface,a0'
;	free_lun,unit
;	myidlmacro,'tmp'
;
; MODIFICATION HISTORY:
; 	Written by:	Manuel Sanchez del Rio (srio@esrf.fr) 97=10=24
;	98/08/20 srio@esrf.fr adds BUFFER keyword.
;
;-
; 
catch, error_status
if error_status ne 0 then begin
  message,/info,'error caught'
  catch, /cancel
  return
endif
; executes an idl macro
;
;  define allowed variables
;
a0 = 0 & a1 = 0 & a2 = 0 & a3 = 0 & a4 = 0 & a5 = 0 
a6 = 0 & a7 = 0 & a8 = 0 & a9 = 0 
b0 = 0 & b1 = 0 & b2 = 0 & b3 = 0 & b4 = 0 & b5 = 0 
b6 = 0 & b7 = 0 & b8 = 0 & b9 = 0 
c0 = 0 & c1 = 0 & c2 = 0 & c3 = 0 & c4 = 0 & c5 = 0 
c6 = 0 & c7 = 0 & c8 = 0 & c9 = 0 
d0 = 0 & d1 = 0 & d2 = 0 & d3 = 0 & d4 = 0 & d5 = 0 
d6 = 0 & d7 = 0 & d8 = 0 & d9 = 0 

helptxt = ['This application permits to execute a bufer of idl commands.',$
      'The commands are executed sequentially using the EXECUTE command',$
      'of IDL. All restrictions of the EXECUTE command apply here as well.',$
      ' ',$
      'It is possible to use variables with names a0,...,a9, b0,...,b9, ',$
      'c0,...,c9 and d0,...,d9. These variables permit to create a sort',$
      'of IDL macro file to be executed.']

command=["a0=dialog_message('Hello World!')"]
if keyword_set(file) then command=read_textfile(file)
if keyword_set(buffer) then command=buffer

if not(keyword_set(noedit)) then begin
  xdisplayfile1,text=command,/modal,group=group,title= $
    'IDL commands to execute', help=helptxt, action=action
  IF action NE 'DO' then return
endif

for i=0,n_elements(command)-1 do begin
  itmp = execute(command(i))
  if itmp NE 1 then begin
    jtmp = widget_message(/QUESTION,dialog_parent=group,$
    ['Error executing IDL command:'+command(i),'Continue?'])
    if jtmp EQ 'No' then return
  endif
endfor
end ; myidlcommand
