; Copyright (c) 1996 European Synchrotron Radiation Facility
;+
; NAME:
;	CW_DROPLIST
;
; PURPOSE:
;	CW_DROPLIST is a compound widget with similar functionality
;	than widget_droplist, but it permits to retrieve the state
;	of the widget by using the widget_control command.
;
; CATEGORY:
;	Compound widgets.
;
; CALLING SEQUENCE:
;		Widget = CW_DROPLIST(Parent)
;
;	To get or set the value of a CW_DROPLIST, use the GET_VALUE and
;	SET_VALUE keywords to WIDGET_CONTROL. 
;
; INPUTS:
;       Parent:		The ID of the parent widget.
;
; KEYWORD PARAMETERS:
;
;	FRAME:		Specifies the width of the frame to be drawn around
;			the base.
;	VALUE:		The initial value of the buttons. It is a string array
;			which element 0 is the state, and elements from 1
;			to n are the values. The same convention is done 
;			in XScrMenu application.
;
;	UVALUE:		The user value to be associated with the widget.
;	XSIZE:		The width of the base. 
;	TITLE:		A title for the widget.
;
; OUTPUTS:
;       The ID of the created widget is returned.
;
; SIDE EFFECTS:
;	This widget generates event structures with the following definition:
;
;         event =  { ID:0L, TOP:0L, HANDLER:0L, VALUE:uvalue }
;
; RESTRICTIONS:
;	Only buttons with textual names are handled by this widget.
;	Bitmaps are not understood.
;
; EXAMPLES:
;	To create a droplist with three elements ('Green','Yellow','Red')
;	and set the default to the 'Green' (index=0):
;		wtmp = cw_droplist(parent,VALUE=['0','Green','Yellow','Red']
;	The same but default to 'Red'
;		wtmp = cw_droplist(parent,VALUE=['2','Green','Yellow','Red']
;	To set the widget to 'Yellow':
;		widget_control,wtmp,set_value='1'
;
; MODIFICATION HISTORY:
;	20 August 1996, M. Sanchez del Rio (srio@esrf.fr)
;-

Pro cw_droplist_Set, id, value
;
child=Widget_Info(id, /Child)
Widget_Control, child, Get_UValue=state, /No_Copy

state.value(0) = strcompress(value,/rem)
Widget_Control,state.dropid,Set_DropList_Select=fix(value)

Widget_Control, child, Set_UValue=state, /No_Copy
END
;
;===============================================================
;
Function cw_droplist_Get, id
child=Widget_Info(id, /Child)
Widget_Control, child, Get_UValue=state, /No_Copy

value=state.value(0)
;help,value

Widget_Control, child, Set_UValue=state, /No_Copy
Return, value
END
;
;===============================================================
;
Function cw_droplist_Event, event

child = Widget_Info(event.handler, /Child)
Widget_Control, child, Get_UValue=state, /No_Copy

;help,/str,state
;
;update state
;
state.value(0) = strcompress(event.index,/rem)


Widget_Control, child, Set_UValue=state, /No_Copy
;
; return event structure
;
WIDGET_CONTROL, event.id, get_uvalue=uvalue
if n_elements(uvalue) EQ 0 then uvalue=0
return, { ID:event.handler, TOP:event.top, HANDLER:0L, value:uvalue }

END
;
;
;===============================================================
;
; This is my version of widget_droplist that permits
; to recover the widget state with widget_control, and
; keeps the state in the first field of the value as it is
; done in XScrMenu
;
;
Function cw_droplist, parent, UValue=uval, Title=init_label, $
  Value=Init_Value,xsize=xsize,Frame=Frame

On_Error,1
If N_Params() NE 1 THEN Message,'Must have one parameter'
If N_Elements(uval) EQ 0 THEN uval = 0
If N_Elements(Init_Value) EQ 0 THEN Init_Value = ['0','Sel a','Sel b']
if N_Elements(frame) EQ 0 then frame=0


cw_tlb = Widget_Base(parent, Row=1, Frame=Frame, Uvalue=uval, $
   Event_Func='cw_droplist_Event',$
   Pro_Set_Value='cw_droplist_Set', $
   Func_Get_Value='cw_droplist_Get')

wstate = Widget_Base(cw_tlb) ; to store state

If N_Elements(init_label) NE 0 THEN $
	label = Widget_Label(cw_tlb, Value=init_label) else label=0L

;Help, Init_Value
List = Init_Value(1:n_elements(Init_Value)-1)
;help,list
drop = Widget_DropList(cw_tlb,Value=List)
if keyword_set(xsize) then widget_control,drop,xsize=xsize

Widget_Control,drop,Set_DropList_Select=fix(Init_Value(0))


state = {labelid:label, dropid:drop, value:init_value}
Widget_Control, wstate, Set_UValue=state , /No_Copy

widget_control,cw_tlb,set_value=init_value(0)

Return, cw_tlb
END
