pro radial_AT, M, CENTER=xy0, INCREMENT=incr, UNROLL=unroll, DIAGRAM=intensity, X=xx, MASK=mask ,ERROR=error
;** *********
;**
;** Radial integration:   "Aurelie Tallandier July 2001 Grenoble".
;** ******************
;**     Input:  M    =2D data matrix (may contains -1 for masked values).
;**     *****   xy0  =[x0,y0] center coordinates (default [n,m]-1/2.)
;**             incr =unit of ray in pixels      (default  0.5)
;**             mask =same dimension as M, contains 1's for masked values otherwise 0's

;**     Output: intensity =result of Radial integration.
;**     ******  M         =Unrolled  matrix if /unroll keyword is set.
;**             xx        =diagram abscissa
;**             error     =diagram errors

common c_rad_at, RR,xc,yc,rmax,rmin

s=size(M)
IF (s(0) ne 2) or (s(1) lt 2) or (s(2) lt 2) THEN RETURN

IF n_elements(xy0)  ne 2 then xy0=([s(1),s(2)]-1.)/2.
IF n_elements(incr) ne 1 then incr=0.5

incr=abs(incr) <(s(1)/2) <(s(2)/2) > 0.01
dr  =incr/2.
xo  =xy0(0)  & yo=xy0(1) & ok=1
IF n_elements(r) eq n_elements(M) then if (xo eq xc) and (yo eq yc) then ok=0

;*****************************CALCUL DES RAYONS******************************
IF ok then BEGIN
        xc=xo & yc=yo

        x =findgen(s(1))
        x =[[x],[x]]
        x =congrid(x,s(1),s(2))

        y =transpose(findgen(s(2)))
        y =congrid(y,s(1),s(2))

        RR=sqrt((x-xo)^2+(y-yo)^2)
        rmax=MAX(RR,min=rmin)

ENDIF

;*****************************MASQUE******************************
R= RR
IF n_elements(mask) eq n_elements(M) then R(WHERE(mask))=-1

;*****************************CALCUL INTENSITE*******************************

; on calcule le  nombre d'elements de r contenus dans un cercle d'epaisseur dr*2
; ce qui nous donne 2 valeurs : un tableau des valeurs qui sont dans r +|-  dr
; et le nombre d'elements de ce tableau.

intensity=fltarr(round((rmax+dr-rmin)/incr)+1)
error    =intensity
xx       =intensity
IF keyword_set(unroll) then mat=fltarr(!pi*2*rmax,n_elements(xx))
j=0
FOR i=rmin,rmax+dr,incr DO BEGIN

; where permet de determiner quelles sont les valeurs de la matrice R qui se
; trouvent dans le cercle d'epaisseur dr*2. Elle renvoie les indices des valeurs
; correspondantes (indice unique au lieu de l'indicage ligne-colonne)
; Ces indices sont places dans un tableau res.

 res=WHERE((R ge (i-dr)) and (R le (i+dr)))
 IF res(0) ge 0 then begin           ; Valeurs trouvees par where

; On veut recuperer les valeurs correspondantes aux indices de res
; pour chaque i afin de calculer l'intensite => m(res)

; on pondere la valeur de chq element par rapport a sa position dans le pixel
; plus le point est proche du centre du pixel ie de i, plus la fraction du
; pixel utilise sera grande

  w=1.-(abs(i-R(res))/(dr*2))
  totm= total(w*M(res))
  totw= total(w)
  intensity(j)= totm /totw
  error(j)=sqrt(totm)/totw
  xx(j)=i
  IF keyword_set(unroll) then mat(0,j)=m(res)
  j=j+1
 ENDIF
ENDFOR
IF j ne n_elements(xx) then begin j=j-1
        intensity=intensity(0:j)
        error    =error(0:j)
        xx       =xx(0:j)
ENDIF

IF keyword_set(unroll) then M=mat

END