PRO Xop_Load_Extension, Group=group

catch, error_status
if error_status ne 0 then begin
   message,/info,'error caught: '+!err_string
   itmp = Dialog_Message(/Error,$
        'XOP_LOAD_EXTENSION: error caught: '+!err_string)
   catch, /cancel
   on_error,2
   RETURN
endif

;
; Get extension .sav file
;
path = Xop_GetEnv('XOP_HOME')+SDep(/ds)+'extensions'

; remove double slashes (confuses dialog_pickfile)
path = StrSubstitute(path,SDep(/ds)+SDep(/ds),SDep(/ds))


idebug=0
IF StrCompress(Xop_GetEnv('XOP_BINARIES_DEBUG'),/Remove_All) NE '' THEN BEGIN
  idebug = 1
  itmp = Dialog_Message(/Info,Dialog_Parent=group,$
    ['Debugging message: Looking for .sav files in directory: ',path])
ENDIF   

ext = Dialog_PickFile(Path=path,Dialog_Parent=group, Title= $
  'Select an XOP extension startup file',Filter='*.sav', /Fix_Filter)
IF ext EQ '' THEN RETURN
;
; gets the name of the extension from the full path
;
list=0
n = StrParse(ext,SDep(/ds),list)
ext1 = StrMid(list[n],0,StrLen(list[n])-4)
;
; loads and starts the extension 
;

command = ext1+';'
IF idebug EQ 1 THEN BEGIN
  itmp = Dialog_Message(/Info,Dialog_Parent=group,/Cancel,$
    ['Debugging message: Executing: ',command])
  IF itmp EQ 'Cancel' THEN Return
ENDIF   
;
Widget_Control,/HourGlass
itmp = Execute(command)
IF itmp NE 1 THEN BEGIN
  itmp = Dialog_Message(/Info,Dialog_Parent=group, $
    ['XOP_LOAD_EXTENSION: Error executing: ',command])
ENDIF

END ; Xop_Load_Extension

