PRO Xop_Input_Run,inputFile, _Extra=extra,Confirm=confirm

;+
; NAME:
;       XOP_INPUT_RUN
;
; PURPOSE:
;       This procedure reads an XOP input file, extract the application
;	name and runs this application with the parameters in the file.
;
; CATEGORY:
;       XOP
;
; CALLING SEQUENCE:
;       Xop_Input_Run, file
;
; OPTIONAL INPUTS:
;	File: the name of the file containg the parameters to be run.
;		(If inputFile is not set, starts the file browser to get it).
;
; KEYWORD PARAMETERS:
;       GROUP:  The widget ID of the group leader of the widget.  If this
;               keyword is specified, the death of the group leader results i n
;               the death of widgets created by XOP_WD.
;	Confirm: Asks for confirmation befor start the run
;	_Extra: any other keyword to be passed to Dialog_PaickFile
;       
; OUTPUTS:
;       Starts the corresponding XOP application and loads the inputs.
;
; SIDE EFFECTS:
;
; PROCEDURE:
;       reads the first line in the <application>.xop file 
;	(i.e. ; xop/xus(v1.9) input file on Thu Dec  3 17:22:34 1998 )
;	and extracts the application name (in this case xus).
;	Loads the parameters in the <application>.xop file and stores 
;	them in the application. 
;
; USE:
;       To start any XOP application from the Main XOP window (File menu).
;
; EXAMPLES:
;       Xop_Input_run
;
; MODIFICATION HISTORY:
;       Written by:     Manuel Sanchez del Rio (srio@esrf.fr) 98/11/05
;
;-
Catch, error_status
IF error_status NE 0 THEN BEGIN
   Message,/Info,'error caught: '+!err_string
   IF SDep(/W) THEN itmp = Dialog_Message(Dialog_Parent=group, $
   /Error,'XOP_INPUT_RUN: error caught: '+!err_string)
   catch, /cancel
   on_error,2
   RETURN
endif

filter='*.xop'

pwd=0
CD,Current=pwd
IF N_Elements(inputFile) EQ 0  THEN BEGIN
  inputFile = Dialog_Pickfile(_Extra=extra,Filter=filter,Path=pwd)
ENDIF 

IF StrCompress(inputFile,/Rem) EQ '' THEN RETURN

;
; Get the first line and find the application
; 
txt = Read_TextFile(inputFile)
line = txt[0]
pos0 = StrPos(line,'/')
pos1 = StrPos(line,'(')
IF pos0 EQ -1 OR pos1 EQ -1 THEN BEGIN
  itmp = Dialog_Message(Dialog_Parent=group,/Error,$
	'XOP_INPUT_RUN: Error reading input file: '+inputFile)
  RETURN
ENDIF
command = StrMid(line,pos0+1,pos1-pos0-1)+",inputFile='"+inputFile+"'"
IF KeyWord_Set(confirm) THEN BEGIN
  itmp = Dialog_Message(Dialog_Parent=group,/Cancel,/Info, $
    'XOP_INPUT_RUN: Executing: '+command)
  IF itmp EQ 'Cancel' THEN RETURN
ENDIF
itmp = Execute(command)
END
