FUNCTION Xop_GetEnv, key

;+
; NAME:
;       XOP_GETENV
;
; PURPOSE:
;       Simulates GetEnv() for MacOS. The same as GetEnv() on other platforms.
;
; CATEGORY:
;       XOP
;
; CALLING SEQUENCE:
;       result = Xop_GetEnv(key)
;
; INPUTS:
;       key = variable name (STRING)
;
; KEYWORD PARAMETERS:
;
; OUTPUTS:
;       Returns the variable value or an empty string if undefined.
;
; SIDE EFFECTS:
;       Calls GetEnv except for MacOS where the data is retrieved from a "silo"
;       buffer.
;
; PROCEDURE:
;       Uses a common block to store the object reference.
;       The "silo" buffer uses keys (variable names) that are case insensitive.
;       The stored data (values) are case sensitive.
;
; COMMON BLOCKS
;       COMMON xop_env, silo
;
; EXAMPLES:
;       print, Xop_GetEnv('XOP_HOME')
;
; MODIFICATION HISTORY:
;       Written  by: Manuel Sanchez del Rio (srio@esrf.fr) 99/01/04
;       Modified by: Roger J. Dejus (dejus@aps.anl.gov) 01/29/99.
;       Uses a "silo" buffer: An object data storage mechanism written by
;       Robert.Mallozzi@msfc.nasa.gov
;-

COMMON xop_env, silo

IF SDep() NE 'MACOS' THEN BEGIN
  RETURN, GetEnv(key)
ENDIF

IF N_Params() EQ 0 THEN BEGIN
  Message, /Continue, 'Incorrect number of arguments.'
  RETURN, 0
ENDIF

IF not Obj_Valid(silo) THEN RETURN, ''
RETURN, silo->Get(key, /Silent)
  
END
