;+
;
;
; =================================  Xxyouts ===============================
;
;   Xxyouts is a widget based graphical interface to the IDL routine
;   xyouts with permits to label plots.
;
;   The main window contains the following controls
;
;	  QUIT AND DISCARD SAVED LABELS: Quit without saving anything
;		and restoring the display as it was before calling
;		xxyouts.
;	  QUIT AND SAVED SAVED LABELS: Quit with saving the labels.
;		Labels are saved as xyouts commands, which can be 
;		passed to other programs by using the BUFFER keyword.
;	  HELP:	Show this text
;	  SAVE LABEL: Save the current label in a buffer. Once one
;		label is saved, the user can continue to define other 
;		labels. You must use this option to keep the label,
;		otherwise it is lost.
;	  REFRESH SCREEN: Refresh the screen as it was before calling
;		Xxyouts plus the saved command in the buffer.
;
;	  There is a text widger where the user writes the text to
;		be used for labeling the plot.
;	  Other control sliders (X and Y positions, Character size,
;		thickness, color and font are straightforward to use.
;	  The last text is the xyouts current command.
;
;		
; ----------------------------------------------------------------------
;
;	NAME:
;		XXYOUTS
;	PURPOSE:
;		to create labels by using xyouts
;	CALLING SEQUENCE:
;		XXYOUTS 
;	OPTIONAL INPUT PARAMETERS:
;	KEYWORD PARAMETERS:
;		GROUP = The widget ID of the widget that calls Xplot.
;		When this ID is specified, a death of the caller results 
;		in a death of Xplot.
;		WINDOW = The id of the window where the labels have to
;		be placed.
;		BUFFER = returning variable (string or array of strings)
;		containing the list of saved xyouts command.
;
;	OUTPUTS:
;		Writes saved command in the BUFFER keyword
;	COMMON BLOCKS:
;		None
;	SIDE EFFECTS:
;	RESTRICTIONS:
;		When dragging labels in the display, deletes the objects
;		under them. Use the refresh button to recover them.
;		Unknown.
;	PROCEDURE:
;		Uses the XYOUTS routine for producing labels.
;	EXAMPLE:
;		plot,[1,4,1,4]
;		xxyouts,BUFFER=buffer
;		(using the interface, savefew labels)
;		
;		;to reproduce the plot with labels do:
;		   plot,[1,4,1,4]   ;plot again
;		   for i=0,n_elements(buffer)-1 do tmp = execute(buffer(i))
;
;	MODIFICATION HISTORY:
;       by  Manuel Sanchez del Rio. ESRF. September 1995
;	97-10-25 srio@esrf.fr Cosmetics.
;
;
;-
;
;=========================================================================
;
pro xxyouts_event,event

widget_control,event.top,GET_UVALUE=state
widget_control,event.id,GET_UVALUE=uval

wset,state.Window

IF keyword_set(uval) then BEGIN
  case uval of
    'Quit': begin
      tmp = widget_message(dialog_parent=event.top,$
	['This option discards all your defined labels.',$
	'Please confirm'],/CANCEL,/DEFAULT_CANCEL)
      if tmp NE 'Cancel' then begin
        widget_control,/HOURGLASS
        tv,state.tvrd
        state.nbuffer=0
        widget_control,state.wBaseBuffer,set_uvalue=state
        widget_control,event.top,/DESTROY
        return
      endif
      end
    'SoftQuit': begin
      widget_control,state.wBaseBuffer,set_uvalue=state
      widget_control,event.top,/DESTROY
      return
      end
    'Help': begin
      widget_control,/HOURGLASS
      doc_library,'xxyouts', PRINT='cat > xxyouts.hlp'
      XDISPLAYFILE1,'xxyouts.hlp',GROUP=event.top, $
	 HEIGHT = 48, /REMOVE
      end
    'Fonts': state.iFonts = event.index
    'Xloadct': Xloadct,GROUP=event.top
    'Refresh': begin
      tv,state.tvrd
      for i=0,state.nbuffer-1 do tmp = execute(state.buffer(i))
      return
      end
    else:
  endcase
ENDIF

widget_control,state.wText,get_value=Text
widget_control,state.wX,get_value=x
widget_control,state.wY,get_value=y
widget_control,state.wCharSize,get_value=CharSize
widget_control,state.wCharThick,get_value=CharThick
widget_control,state.wOrientation,get_value=Orientation
widget_control,state.wColor,get_value=Color

Fonts='!'+strcompress(fix(State.iFonts)+3,/rem)+' '


if state.command_old NE '' then $
	tmp = execute(state.command_old+',COLOR=!p.background')

command='xyouts,/NORM,'+ $
  strcompress(x,/rem)+','+strcompress(y,/rem)+$
  ",'"+Fonts+Text+ "!X',charsize="+strcompress(charsize,/rem)+ $
         ',CharThick='+strcompress(CharThick,/rem)+ $
  ",Orientation="+strcompress(Orientation,/rem) 
state.command_old=command(0)

;help,color
if color ne 255 then begin
  tmpcommand = command(0)+',color='+strcompress(color,/rem)
  ;message,/info,'Executing : '+tmpcommand
  tmp = execute(tmpcommand)
  widget_control,state.wCommand,set_value=tmpcommand
endif else begin
  tmpcommand = command(0)
  ;message,/info,'Executing : '+tmpcommand
  tmp = execute(command(0))
  widget_control,state.wCommand,set_value=tmpcommand
endelse

;widget_control,state.wCommand,set_value=command(0)+strcompress(color,/rem)

IF keyword_set(uval) then $
  if uval EQ 'SaveLabel' then begin
    state.command_old = ''
    widget_control,state.wX,set_value=0.5
    widget_control,state.wY,set_value=0.5
    widget_control,state.wText,set_value=''
    if state.nbuffer GE 199 then begin
      tmp = widget_message(dialog_parent=event.top,$
	'Maximum number of labels is 200',/ERROR)
      goto,out
    endif
    ;if color ne 255 then state.buffer(state.nbuffer) = $
		;command(0)+',color='+strcompress(color,/rem) else $
		;state.buffer(state.nbuffer) = command(0)
    state.buffer(state.nbuffer) = tmpcommand
    widget_control,state.wCommand,set_value = 'Label saved in Xxyouts'+$
     ' buffer with index: '+strcompress(state.nbuffer,/rem)
    state.nbuffer = state.nbuffer+1
    message,/info,'Saved buffer is: '
    for i=0,state.nbuffer-1 do print,state.buffer(i)
  endif

out:
widget_control,event.top,SET_UVALUE=state,/NO_COPY

end
;
;======================================================================
;
pro xxyouts,BUFFER=buffer, GROUP=group,WINDOW=window
;
on_error,2

wBaseBuffer = Widget_base() ; to store the buffer to be returned

wWin = Widget_base(TITLE='Xxyouts')
wBase = Widget_Base(wWin,/Column)

wBase0 = Widget_Base(wBase,/Row)
wQuit = widget_Button(wBase0,VALUE='Quit and discard saved labels',$
	UVALUE='Quit')
wSoftQuit = widget_Button(wBase0,VALUE='Quit and keep saved labels',$
	UVALUE='SoftQuit')
wQuit = widget_Button(wBase0,VALUE='Help',UVALUE='Help')

wBase01 = Widget_Base(wBase,/Row)
wSaveLabel = widget_Button(wBase01,VALUE='Save Label',UVALUE='SaveLabel')
wRefresh = widget_Button(wBase01,VALUE='Refresh Screen',UVALUE='Refresh')


wText = widget_text(wBase,/FRAME,XSIZE=50,/edit,VALUE='text',/ALL_EVENTS)


wBase1 = Widget_Base(wBase,/Row)
wX = cw_fslider(wBase1, /DRAG, TITLE='Normalized Horizontal Position X',$
	/FRAME, MIN=0.,MAX=1.0, XSIZE=205, /EDIT, VALUE=0.5)
wY = cw_fslider(wBase1, /DRAG, TITLE='Normalized Vertical Position Y',$
	/FRAME, MIN=0.,MAX=1.0, XSIZE=205, /EDIT, VALUE=0.5)

wBase2 = Widget_Base(wBase,/Row)
wCharSize = cw_fslider(wBase2, /DRAG, TITLE='Character Size',/FRAME, $
        MIN=0.,MAX=10.0, XSIZE=205, /EDIT,VALUE=1.0)
wCharThick = cw_fslider(wBase2, /DRAG, TITLE='Character Thickness',/FRAME, $
        MIN=0.,MAX=10.0, XSIZE=205, /EDIT,VALUE=1.0)

wBase3 = Widget_Base(wBase,/Row)
wOrientation = cw_fslider(wBase3, /DRAG, TITLE='Orientation [degrees]',$
	/FRAME, MIN=-180.,MAX=180, XSIZE=205, /EDIT,VALUE=0.0)
wBase33 = Widget_Base(wBase3,/Column,/Frame)
wClrTable= widget_button(wBase33, Value='Change color table',UVALUE='Xloadct')
wClrTXT= widget_label(wBase33, Value='Color:',/ALIGN_LEFT)
wColor= cw_clr_index(wBase33, XSIZE=115, YSIZE=25)

wFonts = widget_droplist(wBase, VALUE= $
               ['3:  Simplex Roman', $
                '4:  Simplex Greek', $
                '5:  Duplex Roman', $
                '6:  Complex Roman', $
                '7:  Complex Greek', $
                '8:  Complex Italic', $
                '9:  Math and Special', $
                '10: Special', $
                '11: Gothic English', $
                '12: Simplex Script', $
                '13: Complex Script', $
                '14: Gothic Italian', $
                '15: Gothic German', $
                '16: Cyrillic', $
                '17: Triplex Roman', $
                '18: Triplex Italic' ],TITLE='Font:   ',UVALUE='Fonts')



wCommand = widget_text(wBase,/FRAME,XSIZE=50, VALUE='')
;wCommand = widget_Label(wBase,/FRAME,XSIZE=600, /ALIGN_LEFT, VALUE=$
; '                                                                 ')
        ;/ALIGN_LEFT)

nbuffer = 0
buffer = replicate('',200)

tmp = size(Window)
if tmp(1) EQ 0 then Window=!d.Window
if Window LT 0 then begin
  tmp = widget_message(dialog_parent=group,'Display not set',/ERROR)
  return
endif

widget_control,/HOURGLASS
state = { wText:wText, Window:Window, tvrd:tvrd(), $
  wX:wX, wY:wY, $
  wCharSize:wCharSize, wCharThick:wCharThick, $
  wOrientation:wOrientation, wColor:wColor, iFonts:0, $
  wCommand:wCommand,  command_old:'', $
  wBaseBuffer:wBaseBuffer, buffer:buffer, nbuffer:nbuffer}

widget_control,wWin,/REALIZE,SET_UVALUE=state,/NO_COPY
widget_control,wColor,set_value=255
widget_control,wOrientation,set_value=0.0
xmanager, 'xxyouts', wWin, GROUP_LEADER=group,/MODAL

widget_control,wBaseBuffer,get_uvalue=state
if state.nbuffer GT 0 then buffer = state.buffer(0:state.nbuffer-1) $
  else buffer = 0

end



