;+
;	NAME:
;		XTEXT
;	PURPOSE:
;		to create a window, and show a text.
;	CALLING SEQUENCE:
;		XTEXT 
;	OPTIONAL INPUT PARAMETERS:
;	KEYWORD PARAMETERS:
;		GROUP = The widget ID of the widget that calls Xplot.
;		When this ID is specified, a death of the caller results 
;		in a death of Xtext.
;		TEXT = A string array with the lines of the text: each 
;		element of the array is one line.
;		SIZE = [sx,sy] the horizontel size (sx) and vertical
;		size (sy) of the window in pixels. Default is set to
;		[20,4]
;
;	OUTPUTS:
;		Open a widget utility and present a text.
;	COMMON BLOCKS:
;	SIDE EFFECTS:
;		If not active, starts Xmanager
;	RESTRICTIONS:
;		Unknown.
;	PROCEDURE:
;		Created by changing the Xannounce utility.
;	MODIFICATION HISTORY:
;       by  Manuel Sanchez del Rio. ESRF. December 1993
;		94-02-14 MSR renames from Xannounce to Xtext
;	by Roger J. Dejus, XFD/APS, March 1995
;         	to include the ACTION keyword and the 
;		CANCEL_BUTTON. ACTION returns "DO" if OK
;		was selected and "DONT" if CANCEL was
;		selected.
;
;-
;


PRO xtext_event, event

WIDGET_CONTROL, event.top, GET_UVALUE=ptr
WIDGET_CONTROL, event.id, GET_UVALUE=uvalue

CASE uvalue OF
    "OK": BEGIN
    Widget_Control, ptr, Set_UValue='DO'
    widget_control, event.top, /destroy
    END
    "CANCEL": BEGIN
    Widget_Control, ptr, Set_UValue='DONT'
    widget_control, event.top, /destroy
    END
endcase
end


pro xtext, TEXT=text, GROUP=group, SIZE=size, ACTION=action, CANCEL_BUTTON=cancel

IF NOT(KEYWORD_SET(text)) THEN text = '******************'
ssize=intarr(2)
IF NOT(KEYWORD_SET(size)) THEN ssize=[20,4] ELSE ssize=size
main_base = WIDGET_BASE(title="xtext")
message = WIDGET_BASE(main_base, title='note:', /column)

version	= widget_info(/version)
if version.style EQ 'Motif' OR version.style EQ 'OPEN LOOK' THEN $
	font = '*times-medium-r-*180*' $
else $
	font = ''
;

junk = WIDGET_TEXT(message, ysize = ssize(1), xsize=ssize(0), /FRAME, $
	FONT = font, value= $
	[ text ])
junk = WIDGET_BUTTON(message, value='OK', uvalue='OK', /NO_REL)
				;visuals into psueudo-color graphics mode
IF KEYWORD_SET(cancel) then $
junk = WIDGET_BUTTON(message, value='CANCEL', uvalue='CANCEL', /NO_REL)

WIDGET_CONTROL, /REALIZE, main_base

ptr = Widget_Base()
;WIDGET_CONTROL, main_base, SET_UVAL=[message] ;, base]  ;Save id'
WIDGET_CONTROL, main_base, SET_UVALUE=ptr

XManager, "xtext", main_base, GROUP_LEADER=group, /MODAL

WIDGET_CONTROL, ptr, GET_UVALUE=action
WIDGET_CONTROL, ptr, /Destroy

END
