;
;==================================================================================================
;
;******************************CALCULATION OF LINE POINTS COORDINATES****************************

FUNCTION XPLOT2D_GET_LINE_POINTS,x0,y0,x1,y1,linewidth
   ; given 2 extreme points (long integer coordinates,all positive), this function returns an array
   ; with the subscript of all points of the segment.
   ; linewidth contains the number of pixel in one line (nb of columns)
   ; if xdim > ydim then there is 1 point per column ; else one point per line
   
   ; coordinates of points may be retrieved by : x= subscript MOD linewidth
   ;						 y= long(subscript/linewidth)
   
   x0=long(x0) & y0=long(y0) & x1=long(x1) & y1=long(y1)
   xmin=min([x0,x1])
   ymin=min([y0,y1])
   xmax=max([x0,x1])
   ymax=max([y0,y1])
   xdim=xmax-xmin +1
   ydim=ymax-ymin +1
   
   
   case 1 of
   	xdim : begin	; vertical line
;   		print,'vertical line'
   		line=make_array(ydim,/long,value=x0+ymin*linewidth)	; initial subscript of points
   		line=lindgen(ydim)*linewidth+line
  	end	; endcase for xdim eq 1
   	   
   	ydim : begin	; horizontal line
;   		print,'horizontal line'
   		line=make_array(xdim,/long,value=x0+ymin*linewidth)	; initial subscript of points
   		line=line+lindgen(xdim)
   	end	; endcase for ydim eq 1
   	   
   	xdim ge ydim : begin
;   		print,'xdim ge ydim'
   		
   	        a=float(y1-y0)/float(x1-x0)	; y=ax + b	, |a|<1
   		if x1 lt x0 then b=y1 else b=y0
   		
   	        line=lindgen(xdim)
   	        line=round(line*a+b)
   	        line=line*linewidth+make_array(xdim,/long,value=xmin)+lindgen(xdim)
   	end	; endcase for xdim > ydim
   	
   	else : begin	; ydim > xdim > 1
;   		print,'ydim gt xdim'
   		
   	        a=float(x1-x0)/float(y1-y0)	; x=ay + b	|a|<1
   		if y1 lt y0 then b=x1 else b=x0

   	        line=lindgen(ydim)
   	        line=round(line*a+b)
   	        line=line+( ymin+lindgen(ydim) )*linewidth
   	end	; endcase for ydim > xdim > 1
   	        
   ENDCASE	
   		
   
   
   return,line

END

;
;==================================================================================================
;
FUNCTION XPLOT2D_GET_LINE,wXplot2d
COMMON Xplot2D_common_variables, max_acceptable_screen_size_factor, scroll_step, margin_space, fileDir

   widget_control,wXplot2d,get_uvalue=uvalue
	
	widget_control,uvalue.wGraph,get_value=graphwin
   wset,graphwin
	
	print,'Click on extreme points of segment to integrate'
	cursor,x0,y0,/device,/down   ; getting first point of segment
	cursor,x1,y1,/device,/down   ; getting last point of segment
	
	rebin_factor=uvalue.rebin_factor
	x0=(x0-margin_space)*rebin_factor
	x1=(x1-margin_space)*rebin_factor
	y0=(y0-margin_space)*rebin_factor
	y1=(y1-margin_space)*rebin_factor
	
	ptrData=xplot2d_get_dataptr(wXplot2d)

	oplot,[x0,x1],[y0,y1]

	return,(*ptrData)(xplot2d_get_line_points(x0,y0,x1,y1,(size(*ptrData))(1)))

END
