;-------------------------------------------------------------
;+
; NAME:
;       XLIST1
; PURPOSE:
;       Pop-up list selection widget.
; CATEGORY:
; CALLING SEQUENCE:
;       out = xlist1(list)
; INPUTS:
;       list = string array of possible selections.  in
; KEYWORD PARAMETERS:
;       Keywords:
;         TITLE=txt  title text or text array (def=Select item).
;         MAXSCOLL=n Max allowed lines before scrolling list used
;           (def=20).
;         /WAIT  means wait for a selection before returning.
;           Needed if called from another widget routine.
;         GROUP = The widget ID of the widget that calls xlist1.
;           When this ID is specified, a death of the caller results
;           in a death of xlist1. Must be set when /WAIT is set.
;
; OUTPUTS:
;       out = selected element.                      out
;         Null if Cancel button pressed.
; COMMON BLOCKS:
; NOTES:
; MODIFICATION HISTORY:
;       R. Sterner, 11 Nov, 1993
;	98/08/27 srio@esrf.fr changes to ne (idl5.0) modal widget system.
;		Adds GROUP_LEADER keyword. Renames to xlist1.
;
; Copyright (C) 1993, Johns Hopkins University/Applied Physics Laboratory
; This software may be used, copied, or redistributed as long as it is not
; sold and this copyright notice is reproduced on each copy made.  This
; routine is provided as is without any express or implied warranties
; whatsoever.  Other limitations apply as described in the file disclaimer.txt.
;
; (C) ESRF  1998, modified by srio@esrf.fr (Manuel Sanchez del Rio)
;-
;-------------------------------------------------------------
 
	pro xlist1_event, ev
 
	widget_control, ev.id, get_uval=cmd	; Get command (or list entry).
	widget_control, ev.top, get_uval=res	; Get result address.
 
	if cmd(0) eq 'CANCEL' then begin	; CANCEL button.
	  widget_control, res, set_uval=''	; Return null string.
	  widget_control, ev.top, /dest		; Destroy list widget.
	  return
	endif
 
	txt = cmd(ev.index)			; Selected list entry.
	widget_control, res, set_uval=txt	; Return it.
	widget_control, ev.top, /dest		; Destroy list widget.
	return
 
	end 
 
 
;===================================================================
;	xlist1.pro = Pop-up list selection widget.
;	R. Sterner, 11 Nov, 1993
;===================================================================
 
	function xlist1, list, title=title, help=hlp, maxscroll=maxs, wait=wait,$
	  group_leader = group
 
	if (n_params(0) eq 0) or keyword_set(hlp) then begin
	  print,' Pop-up list selection widget.'
	  print,' out = xlist1(list)'
	  print,'   list = string array of possible selections.  in'
	  print,'   out = selected element.                      out' 
	  print,'     Null if Cancel button pressed.'
	  print,' Keywords:'
	  print,'   TITLE=txt  title text or text array (def=Select item).'
	  print,'   MAXSCOLL=n Max allowed lines before scrolling list used'
	  print,'     (def=20).'
	  print,'   /WAIT  means wait for a selection before returning.'
	  print,'     Needed if called from another widget routine.'
	  return,''
	endif
 
	;--------  Set defaults  ------------
	if n_elements(maxs) eq 0 then maxs=20
	if n_elements(title) eq 0 then title = 'Select item'
 
	;--------  Set up widget  ----------------
	if n_elements(wait) eq 0 then wait=0
	result = widget_base()
	widget_control, result, set_uval=''
	if wait then $
	 top = widget_base(/column, uvalue=result, title=' ',/modal,$
		group_leader=group) else $
	 top = widget_base(/column, uvalue=result, title=' ')
	for i=0, n_elements(title)-1 do t = widget_label(top,val=title(i))
	b = widget_base(top, /row)
	t = widget_button(b, val='Cancel', uval='CANCEL')
	t = widget_list(top, val=list, uval=list,ysize=n_elements(list)<maxs)
	widget_control, top, /real
 
	;--------- Register  ---------
	; srio if n_elements(wait) eq 0 then wait=0
	; srio xmanager, 'xlist1', top, modal=wait
	xmanager, 'xlist1', top , group_leader=group
	widget_control, result, get_uvalue=out
 
	return, out
	end
